package com.pcloud.book.copyright.facade;

import com.pcloud.book.copyright.vo.BookAuthInfoAndServesVO;
import com.pcloud.book.copyright.vo.BookAuthInfoVO;
import com.pcloud.book.copyright.vo.BookAuthInfoWechatVO;
import com.pcloud.book.copyright.vo.GetAuthInfoParam;
import com.pcloud.book.copyright.vo.ListHaveAuthBookParam;
import com.pcloud.book.copyright.vo.ListHaveAuthGroupBookParam;
import com.pcloud.book.copyright.vo.SetAuthStatusParam;
import com.pcloud.book.copyright.vo.SetAuthOpenParam;
import com.pcloud.book.copyright.vo.SetLocationDescVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author lily
 * @date 2018/12/3 10:55
 */
@Api(description = "图书授权信息")
public interface BookAuthInfoFacade {

    @ApiOperation(value = "设置图书版权开启", httpMethod = "POST")
    @RequestMapping(value = "setBookAuthOpen", method = RequestMethod.POST)
    ResponseDto<?> setBookAuthOpen(@RequestHeader("token") String token, @RequestBody SetAuthOpenParam setAuthOpenParam)
            throws PermissionException, BizException;

    @ApiOperation(value = "设置图书版权状态", httpMethod = "POST")
    @RequestMapping(value = "setAuthStatus", method = RequestMethod.POST)
    ResponseDto<?> setAuthStatus(@RequestHeader("token") String token, @RequestBody SetAuthStatusParam setAuthStatusParam)
            throws PermissionException, BizException;

    @ApiOperation(value = "设置位置描述", httpMethod = "POST")
    @RequestMapping(value = "setBookLocationDesc", method = RequestMethod.POST)
    ResponseDto<?> setBookLocationDesc(@RequestHeader("token") String token, @RequestBody SetLocationDescVO setLocationDesc)
            throws PermissionException, BizException;

    @ApiOperation(value = "获取是否有正版授权书", httpMethod = "GET")
    @RequestMapping(value = "getIsHaveAuthBook", method = RequestMethod.GET)
    ResponseDto<Boolean> getIsHaveAuthBook(@RequestHeader("token") String token)
            throws PermissionException, BizException;

    @ApiOperation(value = "获取正版授权信息", httpMethod = "GET")
    @RequestMapping(value = "getInfoByBook", method = RequestMethod.GET)
    ResponseDto<BookAuthInfoVO> getInfoByBook(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
                                              @RequestParam(value = "authBookType", required = false) Integer authBookType)
            throws PermissionException, BizException;

    @ApiOperation(value = "获取正版授权信息(客户端)", httpMethod = "POST")
    @RequestMapping(value = "getInfoByBook4Wechat", method = RequestMethod.POST)
    ResponseDto<BookAuthInfoWechatVO> getInfoByBook4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody GetAuthInfoParam getAuthInfoParam)
            throws PermissionException, BizException;

    @ApiOperation(value = "获取正版授权信息", httpMethod = "GET")
    @RequestMapping(value = "getInfoAndServesByBook", method = RequestMethod.GET)
    ResponseDto<BookAuthInfoAndServesVO> getInfoAndServesByBook(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId,
                                                                @RequestParam("channelId") Long channelId, @RequestParam(value = "authBookType", required = false) Integer authBookType)
            throws PermissionException, BizException;


    @ApiOperation(value = "获取设置过的正版图书信息", httpMethod = "POST")
    @RequestMapping(value = "listHaveSetAuthBook", method = RequestMethod.POST)
    ResponseDto<PageBeanNew> listHaveSetAuthBook(@RequestHeader("token") String token, @RequestBody ListHaveAuthBookParam listHaveAuthBookParam)
            throws PermissionException, BizException;

    @ApiOperation(value = "获取设置过的版权保护社群书信息", httpMethod = "POST")
    @RequestMapping(value = "listHaveSetAuthGroupBook", method = RequestMethod.POST)
    ResponseDto<PageBeanNew> listHaveSetAuthGroupBook(@RequestHeader("token") String token, @RequestBody ListHaveAuthGroupBookParam listHaveAuthGroupBookParam)
            throws PermissionException, BizException;

    @ApiOperation(value = "是否有可以导出的", httpMethod = "GET")
    @RequestMapping(value = "isHaveExport", method = RequestMethod.GET)
    ResponseDto<Boolean> isHaveExport(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId,
                                      @RequestParam("channelId") Long channelId)
            throws PermissionException, BizException;

}
