package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/11/15 14:34
 **/
@Data
public class SelfBookGroupStDTO implements Serializable {
    private static final long serialVersionUID = -4842978566255913073L;

    @ApiModelProperty("书id")
    private Long bookId;

    @ApiModelProperty("书名")
    private String bookName;

    @ApiModelProperty("isbn编号")
    private String isbn;

    @ApiModelProperty("唯一编号")
    private String uniqueNumber;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("编辑名称")
    private String adviserName;

    @ApiModelProperty("出版id")
    private Long agentId;

    @ApiModelProperty("出版社名称")
    private String agentName;

    @ApiModelProperty("社群码id")
    private Long bookGroupId;

    @ApiModelProperty("社群码名称")
    private String groupQrcodeName;

    @ApiModelProperty("社群码url")
    private String groupQrcodeUrl;

    @ApiModelProperty("深度标签id")
    private Long depLabelId;

    @ApiModelProperty("深度标签名称")
    private String depLabelName;

    @ApiModelProperty("目的标签id")
    private Long purLabelId;

    @ApiModelProperty("目的标签名称")
    private String purLabelName;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("小号信息")
    private List<AltIdAndNameDTO> altIdAndNameDTOS;

    @ApiModelProperty("扫码人数")
    private Integer scanPeopleCount;

    @ApiModelProperty("复制暗号人数")
    private Integer copyCipherPeopleCount;

    @ApiModelProperty("累计加好友人数")
    private Integer accAddFriendCount;

    @ApiModelProperty("扫码转化率")
    private Double scanConversionRate;

    @ApiModelProperty("当前好友人数")
    private Integer preFriendCount;

    @ApiModelProperty("已删好友人数")
    private Integer delFriendCount;

    @ApiModelProperty("好友留存率")
    private Double friendKeepRate;

    @ApiModelProperty("已发消息量")
    private Integer sendMessageCount;

    @ApiModelProperty("群分类数量")
    private Integer classifyCount;

    @ApiModelProperty("累计进群人数")
    private Integer accJoinGroupCount;

    @ApiModelProperty("当前群总人数")
    private Integer preInGroupPeopleCount;

    @ApiModelProperty("群消息数量")
    private Integer groupMessageCount;

    @ApiModelProperty("资源服务数量")
    private Integer serveCount;

    @ApiModelProperty("资源点击人数")
    private Integer serveClickPeopleCount;

    @ApiModelProperty("资源点击次数")
    private Integer serveClickCount;

    @ApiModelProperty("社群书平均浏览时长")
    private Long avgBrowseTime;

    @ApiModelProperty("单个服务平均浏览时长")
    private Long oneServeBrowseTime;

    @ApiModelProperty("购买人数")
    private Long buyPeopleCount;

    @ApiModelProperty("销售额")
    private Double saleAmount;

}
