package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.biz.BookGroupClassifyBiz;
import com.pcloud.book.group.facade.BookGroupClassifyFacade;
import com.pcloud.book.group.vo.*;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lily
 * @date 2019/4/16 21:02
 */
@RestController("bookGroupClassifyFacade")
@RequestMapping("bookGroupClassify")
public class BookGroupClassifyFacadeImpl implements BookGroupClassifyFacade {

    @Autowired
    private BookGroupClassifyBiz bookGroupClassifyBiz;

    @Override
    @GetMapping("listAllClassify")
    public ResponseDto<List<ListClassifyVO>> listAllClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        List<ListClassifyVO> listAllClassifys = bookGroupClassifyBiz.listAllClassify(bookGroupId);
        return new ResponseDto<>(listAllClassifys);
    }

    @Override
    @PostMapping("addClassify")
    public ResponseDto<?> addClassify(@RequestHeader("token") String token, @RequestBody AddClassifyVO addClassifyVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.addClassify(addClassifyVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateClassify")
    public ResponseDto<?> updateClassify(@RequestHeader("token") String token, @RequestBody UpdateClassifyVO updateClassifyVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.updateClassify(updateClassifyVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getClassify")
    public ResponseDto<ClassifyVO> getClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        ClassifyVO classifyVO = bookGroupClassifyBiz.getClassify(classifyId);
        return new ResponseDto<>(classifyVO);
    }

    @Override
    @GetMapping("deleteClassify")
    public ResponseDto<?> deleteClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.deleteClassify(classifyId, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateClassifyRank")
    public ResponseDto<?> updateClassifyRank(@RequestHeader("token") String token, @RequestBody UpdateRankVO updateRankVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.updateClassifyRank(updateRankVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("listClassify")
    public ResponseDto<List<ClassifyNameVO>> listClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        List<ClassifyNameVO> classifyNameVOS = bookGroupClassifyBiz.listClassify(bookGroupId);
        return new ResponseDto<>(classifyNameVOS == null ? new ArrayList<>() : classifyNameVOS);
    }

    @Override
    @GetMapping("getClassifyAndGroupCount")
    public ResponseDto<ClassifyAndGroupCountVO> getClassifyAndGroupCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        ClassifyAndGroupCountVO classifyAndGroupCountVO = bookGroupClassifyBiz.getClassifyAndGroupCount(bookGroupId);
        return new ResponseDto<>(classifyAndGroupCountVO == null ? new ClassifyAndGroupCountVO() : classifyAndGroupCountVO);
    }

    @Override
    @GetMapping("getClassifyAndUserCount")
    public ResponseDto<ClassifyAndUserCountVO> getClassifyAndUserCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        ClassifyAndUserCountVO classifyAndGroupCountVO = bookGroupClassifyBiz.getClassifyAndUserCount(bookGroupId);
        return new ResponseDto<>(classifyAndGroupCountVO == null ? new ClassifyAndUserCountVO() : classifyAndGroupCountVO);
    }

    @Override
    @GetMapping("listClassify4Wechat")
    public ResponseDto<List<ListClassify4WechatVO>> listClassify4Wechat(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        List<ListClassify4WechatVO> listClassify4WechatVOS = bookGroupClassifyBiz.listClassify4Wechat(bookGroupId, wechatUserId);
        return new ResponseDto<>(listClassify4WechatVOS);
    }

    @Override
    @GetMapping("listClassify4APP")
    public ResponseDto<List<ListClassify4WechatVO>> listClassify4APP(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        List<ListClassify4WechatVO> listClassify4WechatVOS = bookGroupClassifyBiz.listClassify4APP(bookGroupId, wechatUserId);
        return new ResponseDto<>(listClassify4WechatVOS);
    }

    @Override
    @GetMapping("getGroupQrcode4ClassifyWechat")
    public ResponseDto<GroupQrcode4ClassifyVO> getGroupQrcode4ClassifyWechat(@CookieValue("userInfo") String userInfo, @RequestParam("classifyId") Long classifyId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        GroupQrcode4ClassifyVO groupQrcode4ClassifyVO = bookGroupClassifyBiz.getGroupQrcode4ClassifyWechat(classifyId, wechatUserId);
        return new ResponseDto<>(groupQrcode4ClassifyVO == null ? new GroupQrcode4ClassifyVO() : groupQrcode4ClassifyVO);
    }

    @Override
    @PostMapping("listGroupClassifyByAdviser")
    public ResponseDto<PageBeanNew<BookGroupClassifyVO>> listGroupClassifyByAdviser(@RequestHeader("token") String token, @RequestBody @ApiParam("获取分类列表参数") ListGroupClassifyParam listGroupClassifyParam) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<BookGroupClassifyVO> pageBeanNew = bookGroupClassifyBiz.listGroupClassifyByAdviser(listGroupClassifyParam, adviserId);
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @PostMapping("listBookGroupQrcodeStatistic")
    public ResponseDto<PageBeanNew<BookGroupQrcodeStatisticVO>> listBookGroupQrcodeStatistic(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeParamVO listBookGroupQrcodeParamVO) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<BookGroupQrcodeStatisticVO> pageBeanNew = bookGroupClassifyBiz.listBookGroupQrcodeStatistic(listBookGroupQrcodeParamVO, adviserId);
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @PostMapping("bookGroupQrcodeStatisticExport")
    public ResponseDto<?> bookGroupQrcodeStatisticExport(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeExportParamVO listBookGroupQrcodeExportParamVO) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.bookGroupQrcodeStatisticExport(listBookGroupQrcodeExportParamVO.getClassifyIds(), listBookGroupQrcodeExportParamVO.getBookGroupId(), adviserId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getStatistic4Adviser")
    public ResponseDto<StatisticVO> getStatistic4Adviser(@RequestHeader("token") String token) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        StatisticVO statisticVO = bookGroupClassifyBiz.getStatistic4Adviser(adviserId);
        return new ResponseDto<>(statisticVO == null ? new StatisticVO() : statisticVO);
    }

    @Override
    @PostMapping("listAdviserClassify")
    public ResponseDto<PageBeanNew<AdviserClassifyVO>> listAdviserClassify(@RequestHeader("token") String token, @RequestBody AdviserClassifyParam adviserClassifyParam) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(bookGroupClassifyBiz.listAdviserClassify(adviserId, adviserClassifyParam));
    }

    @ApiOperation("关闭或开启学习报告")
    @GetMapping("updateHasOpenLearningReport")
    @Override
    public ResponseDto<?> updateHasOpenLearningReport(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("classifyId") @ApiParam("分类id") Long classifyId,
            @RequestParam("hasOpenLearningReport") @ApiParam("是否开启学习报告") Boolean hasOpenLearningReport
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.updateHasOpenLearningReport(classifyId,hasOpenLearningReport,partyId);
        return new ResponseDto<>();
    }

    @ApiOperation("获取群分类学习报告相关列表")
    @GetMapping("listClassifyForLearningReport")
    @Override
    public ResponseDto<?> listClassifyForLearningReport(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage,
            @RequestParam(value = "keyword", required = false) @ApiParam("关键词") String keyword
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(bookGroupClassifyBiz.listClassifyForLearningReport(currentPage,numPerPage,keyword,partyId));
    }


    @ApiOperation("拖动排序")
    @PostMapping("dragSortClassify")
    @Override
    public ResponseDto<?> dragSortClassify(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody List<Long> classifyIds
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.dragSortClassify(classifyIds);
        return new ResponseDto<>();
    }


    @Override
    @GetMapping("clickClassify")
    public ResponseDto<?> clickClassify(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId,
                                       @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        bookGroupClassifyBiz.clickClassify(wechatUserId,bookGroupId,classifyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getClassifyIngoreDelete")
    public ResponseDto<?> getClassifyIngoreDelete(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        List<ListClassifyVO> classifyVOS = bookGroupClassifyBiz.getClassifyIngoreDelete(bookGroupId);
        return new ResponseDto<>(classifyVOS);
    }

    @ApiOperation("根据类型获取分类数量")
    @GetMapping("getClassifyCountByJoinGroupType")
    @Override
    public ResponseDto<?> getClassifyCountByJoinGroupType(
            @RequestHeader("token") String token,
            @RequestParam(value = "joinGroupType", required = false) Integer joinGroupType
    ) throws PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)) {
            throw new PermissionException(PermissionException.PERMISSION_NOT_FOUND);
        }
        return new ResponseDto<>(bookGroupClassifyBiz.getClassifyCountByJoinGroupType(joinGroupType));
    }


}
