package com.pcloud.book.guide.mapper;

import com.pcloud.book.guide.entity.PcloudRobotSilence;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface PcloudRobotSilenceMapper {
    int deleteByPrimaryKey(Integer id);

    int insert(PcloudRobotSilence record);

    int insertSelective(PcloudRobotSilence record);

    PcloudRobotSilence selectByPrimaryKey(Integer id);

    int updateByPrimaryKeySelective(PcloudRobotSilence record);

    int updateByPrimaryKey(PcloudRobotSilence record);

    /**
     * 查询所有平台端 引导语 缄默设置相关的机器人
     */
    List<String> listRobots();

    /**
     * 根据机器人wxid获取缄默时长
     */
    Integer getSilenceDurationByRobotWxId(@Param("wxId") String wxId, @Param("pcloudClassifyId") Integer pcloudClassifyId);

    /**
     * 设置机器人缄默时长
     */
    void setSilenceDuration(@Param("robotWxId") String robotWxId, @Param("silenceDuration") Integer silenceDuration,
                            @Param("pcloudClassifyId") Integer pcloudClassifyId);

    PcloudRobotSilence get(@Param("wxId") String wxId, @Param("pcloudClassifyId") Integer pcloudClassifyId);
}