package com.pcloud.book.guide.service;

import com.alibaba.fastjson.JSONObject;
import com.pcloud.book.guide.biz.PcloudRobotWakeUpBiz;
import com.pcloud.book.guide.dto.WakeUpInfoDto;
import com.pcloud.book.guide.service.PcloudRobotWakeUpService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.Map;

import static com.pcloud.book.guide.constant.PcloudGuideRedisConstant.PCLOUD_ROBOT_WAKE_UP_SUFFIX;


@RestController
@RequestMapping("pcloudRobotWakeUpService")
@Slf4j
public class PcloudRobotWakeUpServiceImpl implements PcloudRobotWakeUpService {

    @Autowired
    private PcloudRobotWakeUpBiz pcloudRobotWakeUpBiz;

    @ApiOperation("定时任务执行方法")
    @PostMapping("/doJob")
    public void doJob(@RequestBody Map<String, Object> map)throws BizException {
        log.info("PcloudRobotWakeUpServiceImpl.doJob 开始执行定时任务");
        Integer wakeUpId = (Integer) map.get("wakeUpId");
        pcloudRobotWakeUpBiz.doJob(wakeUpId);
    }


    @ApiOperation("手动自动唤醒设置缓存")
    @GetMapping("/hset")
    public ResponseDto<?> hset(@RequestParam("wxid") String wxid,
                               @RequestParam("robotId")  String robotId,
                               @RequestParam("ip") String ip,
                               @RequestParam("day") Integer day,
                               @RequestParam("wakeUpId") Integer wakeUpId){
        WakeUpInfoDto wakeUpInfoDto = new WakeUpInfoDto();
        wakeUpInfoDto.setIp(ip);
        wakeUpInfoDto.setTime(DateUtils.addDay(new Date(),day));
        JedisClusterUtils.hset(robotId + PCLOUD_ROBOT_WAKE_UP_SUFFIX, wxid, JSONObject.toJSONString(wakeUpInfoDto));
        return new ResponseDto<>();
    }

}
