package com.pcloud.book.keywords.dao.impl;

import com.pcloud.book.keywords.dao.NotKeywordItemDao;
import com.pcloud.book.keywords.entity.NotKeywordItem;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("notKeywordItemDao")
public class NotKeywordItemDaoImpl extends BaseDaoImpl<NotKeywordItem> implements NotKeywordItemDao {
    @Override
    public Integer batchInsert(List<NotKeywordItem> list) {
        return this.getSqlSession().insert(this.getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByTemplateId(Long templateId) {
        this.getSqlSession().delete(this.getStatement("deleteByTemplateId"), templateId);
    }

    @Override
    public List<NotKeywordItem> getListByTemplateIds(List<Long> templateIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("templateIds",templateIds);
        return this.getSqlSession().selectList(this.getStatement("getListByTemplateIds"), map);
    }
}
