package com.pcloud.book.keywords.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/23 15:38
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GuideVO implements Serializable {

    @ApiModelProperty("欢迎语标识")
    private Long id;

    @ApiModelProperty("社群码标识")
    private Long bookGroupId;

    @ApiModelProperty("分类标识")
    private Long classifyId;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private  Long channelId;

    @ApiModelProperty("是否推荐公众号（0 不推荐 1推荐）")
    private Integer isRecommend;

    @ApiModelProperty("推荐语")
    private String recommendLanguage;

    @ApiModelProperty("回复消息")
    private List<ReplyMessageVO> replyMessages;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Integer getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Integer isRecommend) {
        this.isRecommend = isRecommend;
    }

    public String getRecommendLanguage() {
        return recommendLanguage;
    }

    public void setRecommendLanguage(String recommendLanguage) {
        this.recommendLanguage = recommendLanguage;
    }

    public List<ReplyMessageVO> getReplyMessages() {
        return replyMessages;
    }

    public void setReplyMessages(List<ReplyMessageVO> replyMessages) {
        this.replyMessages = replyMessages;
    }

    @Override
    public String toString() {
        return "GuideVO{" +
                "id=" + id +
                ", bookGroupId=" + bookGroupId +
                ", classifyId=" + classifyId +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", isRecommend=" + isRecommend +
                ", recommendLanguage='" + recommendLanguage + '\'' +
                ", replyMessages=" + replyMessages +
                '}';
    }
}
