/**
 * 
 */
package com.pcloud.book.mq.topic;

import com.pcloud.book.copyright.biz.BookAuthOrderBiz;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.facade.tradecenter.entity.Genuine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @描述：
 *   正版授权金监听
 */
@Component
@RabbitListener(queues = MQTopicConumer.GENUINE)
public class GenuineListener {

	/**
	 * 
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(GenuineListener.class);

	@Autowired
	private BookAuthOrderBiz bookAuthOrderBiz;

	@RabbitHandler
	@ParamLog("授权金购买")
	public void process(Genuine genuine) throws BizException {
		if (genuine == null) return;
		try{
			bookAuthOrderBiz.insertOrder(genuine);
		} catch (Exception e) {
			LOGGER.error("【授权金购买】消费topic,JMS异常,<ERROR>:" + e.getMessage(), e);
			return;
		}
	}
}
