package com.pcloud.book.pcloudkeyword.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.consumer.content.ResourceConsr;
import com.pcloud.book.consumer.wechatgroup.WechatGroupConsr;
import com.pcloud.book.guide.biz.PcloudGuideBiz;
import com.pcloud.book.guide.biz.PcloudRobotWakeUpBiz;
import com.pcloud.book.guide.mapper.PcloudRobotSilenceMapper;
import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotBiz;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotClassifyBiz;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotMemoBiz;
import com.pcloud.book.pcloudkeyword.dao.*;
import com.pcloud.book.pcloudkeyword.dto.PcloudRobotMemoGroupDto;
import com.pcloud.book.pcloudkeyword.dto.PcloudTdDTO;
import com.pcloud.book.pcloudkeyword.dto.PcloudTdReplyDTO;
import com.pcloud.book.pcloudkeyword.entity.*;
import com.pcloud.book.pcloudkeyword.enums.WelcomeReplyTypeEnum;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotResponseVO;
import com.pcloud.book.pcloudkeyword.set.PcloudRobotSet;
import com.pcloud.book.push.biz.SelfPushBiz;
import com.pcloud.book.util.common.ThreadPoolUtils;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.QrcodeUtils;
import com.pcloud.common.utils.httpclient.UrlUtils;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.contentcenter.resource.dto.ResourceDTO;
import com.pcloud.wechatgroup.message.dto.SendTextDTO;
import com.pcloud.wechatgroup.selfrobot.dto.RobotBaseInfoDTO;
import com.sdk.wxgroup.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component("pcloudRobotMemoBiz")
public  class PcloudRobotMemoBizImpl implements PcloudRobotMemoBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(PcloudRobotMemoBizImpl.class);


    @Autowired
    private PcloudRobotMemoDao pcloudRobotMemoDao;

    @Autowired
    private PcloudRobotMemoGroupDao pcloudRobotMemoGroupDao;

    @Override
    public void createMemoGroup(PcloudRobotMemoGroup pcloudRobotMemoGroup) {
        pcloudRobotMemoGroupDao.insert(pcloudRobotMemoGroup);
    }

    @Override
    public void createPcloudRobotMemo(PcloudRobotMemo pcloudRobotMemo) {
        pcloudRobotMemoDao.insert(pcloudRobotMemo);
    }

    @Override
    public void updatePcloudRobotMemo(PcloudRobotMemo pcloudRobotMemo) {
        pcloudRobotMemoDao.updateById(pcloudRobotMemo);
    }

    @Override
    public void deleteById(Long memoId) {
        pcloudRobotMemoDao.deleteById(memoId);
    }

    @Override
    public List<PcloudRobotMemoGroupDto> getPcloudRobotMemo() {
        List<PcloudRobotMemoGroupDto> dtoList=new ArrayList<>();
        List<PcloudRobotMemoGroup> pcloudRobotMemoGroupList=  pcloudRobotMemoGroupDao.getAllGroup();
        for (PcloudRobotMemoGroup group:pcloudRobotMemoGroupList) {
            PcloudRobotMemoGroupDto dto=new PcloudRobotMemoGroupDto();
            dto.setGroupId(group.getId());
            dto.setGroupName(group.getGroupName());
           List<PcloudRobotMemo> list=pcloudRobotMemoDao.getMemoListByGroupId(group.getId());
           dto.setPcloudRobotMemoList(list);
            dtoList.add(dto);

        }
        return dtoList;
    }

    @Override
    public List<PcloudRobotMemo> getMemoByContext(String context) {
        return pcloudRobotMemoDao.getMemoByContext(context);
    }

    @Override
    public void updateMemoGroup(PcloudRobotMemoGroup pcloudRobotMemoGroup) {
        pcloudRobotMemoGroupDao.updateById(pcloudRobotMemoGroup);
    }

    @Override
    public void deleteMemoGroupById(Long id) {
        pcloudRobotMemoGroupDao.deleteById(id);
        List<PcloudRobotMemo> list = pcloudRobotMemoDao.getMemoListByGroupId(id);
        for (PcloudRobotMemo memo:list) {
            pcloudRobotMemoDao.deleteById(memo.getId());
        }
    }
}
