package com.pcloud.book.pcloudkeyword.dao;

import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordName;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface PcloudKeywordNameDao extends BaseDao<PcloudKeywordName> {

    Integer batchInsert(List<PcloudKeywordName> list);

    void deleteByPcloudKeywordId(Long id);

    List<PcloudKeywordName> getByPcloudKeywordId(Long pcloudKeywordId);

    List<PcloudKeywordName> getByPcloudKeywordIds(List<Long> pcloudKeywordIds);

    void deleteByKeywordIds(List<Long> pcloudKeywordIds);

    /**
     * 根据分类查名称
     * @param keywordClassifyId
     * @param keywordId，不包含的关键词
     * @return
     */
    List<String> getNameListByClassifyId(Long keywordClassifyId, Long keywordId);
}
