package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudkeyword.dao.PcloudRobotWelcomeDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("pcloudRobotWelcomeDao")
public class PcloudRobotWelcomeDaoImpl extends BaseDaoImpl<PcloudRobotWelcome> implements PcloudRobotWelcomeDao {

    @Override
    public List<PcloudRobotWelcome> getRobotWelcomeListByPcloudRobotId(Long pcloudRobotId) {
        return super.getSqlSession().selectList(getStatement("getRobotWelcomeListByPcloudRobotId"), pcloudRobotId);
    }

    @Override
    public void deleteByPcloudRobotId(Long pcloudRobotId) {
        super.getSqlSession().delete(getStatement("deleteByPcloudRobotId"), pcloudRobotId);
    }

    @Override
    public void batchInsert(List<PcloudRobotWelcome> robotWelcomeList) {
        super.getSqlSession().insert(getStatement("batchInsert"), robotWelcomeList);
    }

    @Override
    public List<PcloudRobotWelcome> getRobotWelcomeListByPcloudClassifyId(Long pcloudClassifyId) {
        return super.getSqlSession().selectList(getStatement("getRobotWelcomeListByPcloudClassifyId"), pcloudClassifyId);
    }

    @Override
    public void deleteByPcloudClassifyId(Long pcloudClassifyId) {
        super.getSqlSession().delete(getStatement("deleteByPcloudClassifyId"), pcloudClassifyId);
    }

}
