package com.pcloud.book.pcloudkeyword.set;

import com.pcloud.appcenter.app.dto.AppDto;
import com.pcloud.book.consumer.app.AppConsr;
import com.pcloud.book.consumer.channel.QrcodeSceneConsr;
import com.pcloud.book.consumer.content.ResourceConsr;
import com.pcloud.book.consumer.resource.ProductConsr;
import com.pcloud.book.group.enums.AppAndProductTypeEnum;
import com.pcloud.book.group.tools.SendWeixinRequestTools;
import com.pcloud.book.keywords.enums.ReplyTypeEnum;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.book.pcloudkeyword.enums.WelcomeReplyTypeEnum;
import com.pcloud.channelcenter.wechat.dto.AccountSettingDto;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.httpclient.UrlUtils;
import com.pcloud.contentcenter.resource.dto.ResourceDTO;
import com.pcloud.resourcecenter.product.dto.ProductDto;
import com.sdk.wxgroup.SendArticleMessageVO;
import com.sdk.wxgroup.WxGroupSDK;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudRobotSet")
public class PcloudRobotSet {

    @Autowired
    private ResourceConsr resourceConsr;
    @Autowired
    private ProductConsr productConsr;
    @Autowired
    private AppConsr appConsr;
    @Autowired
    private QrcodeSceneConsr qrcodeSceneConsr;

    @ParamLog("填充欢迎语回复")
    public void fillRobotWelcome(List<PcloudRobotWelcome> robotWelcomeList) {
        if(ListUtils.isEmpty(robotWelcomeList)){
            return;
        }
        List<Long> resourceIds=new ArrayList<>();
        for (PcloudRobotWelcome robotWelcome : robotWelcomeList){
            Integer type = robotWelcome.getReplyType();
            if (WelcomeReplyTypeEnum.RESOURCE.value.equals(type)){
                resourceIds.add(robotWelcome.getResourceId());
            }
        }
        Map<Long, ResourceDTO> resourceDTOMap=new HashMap<>();
        if (!ListUtils.isEmpty(resourceIds)){
            resourceDTOMap = resourceConsr.mapByIds(resourceIds);
        }
        for (PcloudRobotWelcome robotWelcome : robotWelcomeList){
            Integer type = robotWelcome.getReplyType();
            if (WelcomeReplyTypeEnum.RESOURCE.value.equals(type)){
                ResourceDTO resourceDTO = resourceDTOMap.get(robotWelcome.getResourceId());
                if (resourceDTO != null){
                    robotWelcome.setResourceName(resourceDTO.getResourceName());
                    robotWelcome.setResourceUrl(resourceDTO.getFileUrl());
                    robotWelcome.setResourceTypeCode(resourceDTO.getTypeCode());
                    robotWelcome.setResourceTypeName(resourceDTO.getTypeName());
                    robotWelcome.setFileType(resourceDTO.getFileType());
                    robotWelcome.setFileSize(resourceDTO.getFileSize());
                    robotWelcome.setResourcePdfItems(resourceDTO.getResourcePdfItems());
                    robotWelcome.setResourceOfficeItemDTOs(resourceDTO.getResourceOfficeItemDTOs());
                }
            }
        }
    }
    public void sendAppOrProductReply(String serveType, Long serveId, String linkUrl,
                                      String robotWxId, String userWxId, String ip, Integer code) {
        AccountSettingDto accountSettingDto = null;
        String typeName = "";
        String picUrl = "";
        String title = "";
        String resultUrl = "";
        if (AppAndProductTypeEnum.APP.value.equals(serveType)) {
            AppDto appDto = appConsr.getBaseById(serveId);
            if (appDto != null) {
                accountSettingDto = qrcodeSceneConsr.getWechatInfo(appDto.getChannelId());
                typeName = appDto.getTypeName();
                picUrl = appDto.getSquareImg();
                title = appDto.getTitle();
            }
            if(accountSettingDto != null) {
                String endUrl = linkUrl + "&wxId=" + userWxId + "&robotWxId=" + robotWxId;
                String resultLinkUrl = SendWeixinRequestTools.splitUrl(accountSettingDto, endUrl);
                resultUrl = UrlUtils.getShortUrl4Own(resultLinkUrl);
            }
        }
        if (AppAndProductTypeEnum.PRODUCT.value.equals(serveType)) {
            ProductDto productDto = productConsr.getProBaseById(serveId);
            if (productDto != null) {
                typeName = productDto.getProductTypeDto() == null ? "" : productDto.getProductTypeDto().getTypeName();
                picUrl = productDto.getCoverImg();
                title = productDto.getProductName();
                resultUrl = UrlUtils.getShortUrl4Own(linkUrl + "&wxId=" + userWxId + "&robotWxId=" + robotWxId);
            }
        }
        if(!StringUtils.isEmpty(resultUrl)) {
            SendArticleMessageVO sendArticleMessageVO = new SendArticleMessageVO();
            sendArticleMessageVO.setCode(code);
            sendArticleMessageVO.setAltId(robotWxId);
            sendArticleMessageVO.setDescription(typeName);
            sendArticleMessageVO.setWxGroupId(userWxId);
            sendArticleMessageVO.setLinkUrl(resultUrl);
            sendArticleMessageVO.setPicUrl(picUrl);
            sendArticleMessageVO.setTitle(title);
            sendArticleMessageVO.setIp(ip);
            WxGroupSDK.sendArticleMessage(sendArticleMessageVO);
        }
    }

}
