package com.pcloud.book.personal.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.consumer.reader.ReaderConsr;
import com.pcloud.book.personal.biz.PcloudUserLabelBiz;
import com.pcloud.book.personal.biz.PersonalMedalBiz;
import com.pcloud.book.personal.check.PersonalCheck;
import com.pcloud.book.personal.dto.PcloudLabelGroupDto;
import com.pcloud.book.personal.enums.StarReceiveTypeEnum;
import com.pcloud.book.personal.mapper.PcloudLabelMapper;
import com.pcloud.book.personal.mapper.PcloudUserLabelMapper;
import com.pcloud.book.personal.dto.PcloudUserLabelDto;
import com.pcloud.book.personal.entity.PcloudUserLabel;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service("pcloudUserLabelBiz")
public class PcloudUserLabelBizImpl implements PcloudUserLabelBiz {

    @Autowired
    private PcloudUserLabelMapper pcloudUserLabelMapper;
    @Autowired
    private PersonalCheck personalCheck;
    @Autowired
    private PcloudLabelMapper pcloudLabelMapper;
    @Autowired
    private PersonalMedalBiz personalMedalBiz;
    @Autowired
    private ReaderConsr readerConsr;

    @Override
    @ParamLog("获取用户的标签列表")
    public List<PcloudUserLabelDto> getPcloudUserLabelList(String wxUsrerId) {
        if (StringUtil.isEmpty(wxUsrerId)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"wxUsrerId为空");
        }
        return pcloudUserLabelMapper.getPcloudUserLabelList(wxUsrerId);
    }

    @Override
    @ParamLog("新增用户的标签列表")
    public void addPcloudUserLabel(List<PcloudUserLabel> pcloudUserLabels, Long wechatUserId) {
        if (ListUtils.isEmpty(pcloudUserLabels)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"pcloudUserLabels为空！");
        }
        pcloudUserLabels.stream().forEach(e ->{
            personalCheck.checkUserLabel(e);
        });
       String wxUserId = pcloudUserLabels.get(0).getWxUserId();
        //Long wechatUserId = readerConsr.getWechatUserId(pcloudUserLabel.getWxUserId(),null);
        List<PcloudUserLabelDto> pcloudUserLabelDtos = this.getPcloudUserLabelList(wxUserId);
        List<Integer> labelIdList = pcloudUserLabels.stream().map(e -> e.getPcloudLabelId()).collect(Collectors.toList());
        if (!ListUtils.isEmpty(pcloudUserLabelDtos)){
            List<Integer> labelIds = pcloudUserLabelDtos.stream().map(e -> e.getPcloudLabelId()).collect(Collectors.toList());
            labelIds.retainAll(labelIdList);
            if (labelIds.size() > 0){
                throw new  BookBizException(BookBizException.PARAM_IS_NULL,"标签已存在！");
            }
        }
        if (ListUtils.isEmpty(pcloudUserLabelDtos) && null != wechatUserId){
            personalMedalBiz.receiveStar(wechatUserId, StarReceiveTypeEnum.LIKE);
        }
        pcloudUserLabelMapper.batchInsert(pcloudUserLabels);
    }

    @Override
    @ParamLog("删除用户的标签列表")
    public void deletePcloudUserLabel(Integer id) {
        if (null != id){
            pcloudUserLabelMapper.deleteByPrimaryKey(id);
        }
    }

    @Override
    public List<PcloudLabelGroupDto> getPcloudLabelGroup() {
        return pcloudLabelMapper.getPcloudLabelGroup();
    }

    @Override
    public void batchDeletePcloudUserLabel(List<Integer> ids) {
        if (!ListUtils.isEmpty(ids)){
            pcloudUserLabelMapper.batchDeletePcloudUserLabel(ids);
        }
    }


}
