package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageWakeupDao;
import com.pcloud.book.personalstage.entity.PersonalStageWakeup;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("personalStageWakeup")
public class PersonalStageWakeupDaoImpl extends BaseDaoImpl<PersonalStageWakeup> implements PersonalStageWakeupDao {
    @Override
    public Integer batchInsert(List<PersonalStageWakeup> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByPersonalStageId(Long personalStageId) {
        super.getSqlSession().delete(getStatement("deleteByPersonalStageId"), personalStageId);
    }

    @Override
    public List<PersonalStageWakeup> getListByPersonalStageId(Long personalStageId) {
        return super.getSqlSession().selectList(getStatement("getListByPersonalStageId"), personalStageId);
    }

    @Override
    public PersonalStageWakeup getFirstWakeup(Long personalStageId) {
        return super.getSqlSession().selectOne(getStatement("getFirstWakeup"), personalStageId);
    }
}
