package com.pcloud.book.push.dao;

import com.pcloud.book.push.entity.PushGroupRecord;
import com.pcloud.book.push.enums.PushStatusEnum;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:46
 **/
public interface PushGroupRecordDao extends BaseDao<PushGroupRecord> {

    /**
     * 批量插入
     */
    Integer batchInsert(List<PushGroupRecord> pushGroupRecords);

    /**
     * 更新状态
     */
    void updateStateById(Integer pushGroupRecordId, Integer pushStatus);

    /**
     * 获取记录集合
     */
    List<PushGroupRecord> getListByPushRecordId(Long pushRecordId);

    /**
     * 根据群发记录id更新状态
     */
    void updateStateByPushRecordId(Long pushRecordId, Integer pushStatus);
}
