package com.pcloud.book.push.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/10 12:57
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PushPlanDTO implements Serializable {
    private static final long serialVersionUID = -3956311764049212139L;

    @ApiModelProperty("计划id")
    private Long pushPlanId;

    @ApiModelProperty("分类id")
    private List<Long> classifyIds;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("修改人")
    private Long updateUser;

    private List<PushPlanItemDTO> pushPlanItemDTOList;

    private List<PlanClassifyDTO> planClassifyDTOList;

    public Long getPushPlanId() {
        return pushPlanId;
    }

    public void setPushPlanId(Long pushPlanId) {
        this.pushPlanId = pushPlanId;
    }

    public List<Long> getClassifyIds() {
        return classifyIds;
    }

    public void setClassifyIds(List<Long> classifyIds) {
        this.classifyIds = classifyIds;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public List<PushPlanItemDTO> getPushPlanItemDTOList() {
        return pushPlanItemDTOList;
    }

    public void setPushPlanItemDTOList(List<PushPlanItemDTO> pushPlanItemDTOList) {
        this.pushPlanItemDTOList = pushPlanItemDTOList;
    }

    public List<PlanClassifyDTO> getPlanClassifyDTOList() {
        return planClassifyDTOList;
    }

    public void setPlanClassifyDTOList(List<PlanClassifyDTO> planClassifyDTOList) {
        this.planClassifyDTOList = planClassifyDTOList;
    }

    @Override
    public String toString() {
        return "PushPlanDTO{" +
                "pushPlanId=" + pushPlanId +
                ", classifyIds=" + classifyIds +
                ", isDelete=" + isDelete +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                ", pushPlanItemDTOList=" + pushPlanItemDTOList +
                ", planClassifyDTOList=" + planClassifyDTOList +
                '}';
    }
}
