package com.pcloud.book.push.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 16:03
 **/
@ApiModel("消息分类群推送记录id")
public class PushGroupRecord extends BaseEntity {

    @ApiModelProperty("推送记录id")
    private Long pushRecordId;

    @ApiModelProperty("消息推送id")
    private Long pushId;

    @ApiModelProperty("书id")
    private Long bookId;

    @ApiModelProperty("群分类标识")
    private Long classifyId;

    @ApiModelProperty("微信二维码标识")
    private Long bookGroupQrcodeId;

    @ApiModelProperty("发送状态")
    private Integer pushStatus;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("修改人")
    private Long updateUser;

    public Long getPushRecordId() {
        return pushRecordId;
    }

    public void setPushRecordId(Long pushRecordId) {
        this.pushRecordId = pushRecordId;
    }

    public Long getPushId() {
        return pushId;
    }

    public void setPushId(Long pushId) {
        this.pushId = pushId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getBookGroupQrcodeId() {
        return bookGroupQrcodeId;
    }

    public void setBookGroupQrcodeId(Long bookGroupQrcodeId) {
        this.bookGroupQrcodeId = bookGroupQrcodeId;
    }

    public Integer getPushStatus() {
        return pushStatus;
    }

    public void setPushStatus(Integer pushStatus) {
        this.pushStatus = pushStatus;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public String toString() {
        return "PushGroupRecord{" +
                "pushRecordId=" + pushRecordId +
                ", pushId=" + pushId +
                ", bookId=" + bookId +
                ", classifyId=" + classifyId +
                ", bookGroupQrcodeId=" + bookGroupQrcodeId +
                ", pushStatus=" + pushStatus +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                "} " + super.toString();
    }
}
