package com.pcloud.book.reading.dao.impl;

import com.pcloud.book.reading.dao.ReadingActivityDao;
import com.pcloud.book.reading.entity.ReadingActivity;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @描述：共读活动基本设置
 * @作者：zhuyajie
 * @创建时间：17:27 2020/1/14
 * @版本：1.0
 */
@Component("readingActivityDao")
public class ReadingActivityDaoImpl extends BaseDaoImpl<ReadingActivity> implements ReadingActivityDao {

    @Override
    public void updateAdditionSetting(ReadingActivity readingActivity) {
        getSessionTemplate().update(getStatement("updateAdditionSetting"), readingActivity);
    }

    @Override
    public ReadingActivity getByTheme(String theme) {
        return this.getSqlSession().selectOne("getByTheme", theme);
    }

    public Boolean themeExist(String theme) {
        return getSessionTemplate().selectOne(getStatement("themeExist"), theme);
    }

    @Override
    public ReadingActivity getByThemeAndJoinCondition(String theme, Integer joinCondition) {
        Map<String, Object> map = new HashMap<>();
        map.put("theme", theme);
        map.put("joinCondition", joinCondition);
        return this.getSqlSession().selectOne("getByThemeAndJoinCondition", map);
    }

    @Override
    public ReadingActivity getJoinActivityByKeyword(String altId, String wxUserId, String text) {
        Map<String, Object> map = new HashMap<>();
        map.put("altId", altId);
        map.put("wxUserId", wxUserId);
        map.put("joinKeyword", text);
        return getSessionTemplate().selectOne(getStatement("getJoinActivityByKeyword"), map);
    }

}
