package com.pcloud.book.skill.dao.impl;

import com.pcloud.book.skill.dao.PcloudSkillGuideDao;
import com.pcloud.book.skill.entity.PcloudSkillGuide;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudSkillGuideDao")
public class PcloudSkillGuideDaoImpl extends BaseDaoImpl<PcloudSkillGuide> implements PcloudSkillGuideDao {
    @Override
    public Integer batchInsert(List<PcloudSkillGuide> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByPcloudSkillId(Long pcloudSkillId) {
        super.getSqlSession().delete(getStatement("deleteByPcloudSkillId"), pcloudSkillId);
    }

    @Override
    public List<PcloudSkillGuide> getListByPcloudSkillId(Long pcloudSkillId) {
        return super.getSqlSession().selectList(getStatement("getListByPcloudSkillId"), pcloudSkillId);
    }

    @Override
    public List<PcloudSkillGuide> getListByPcloudSkillIds(List<Long> pcloudSkillIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("pcloudSkillIds",pcloudSkillIds);
        return super.getSqlSession().selectList(getStatement("getListByPcloudSkillIds"), map);
    }
}
