package com.pcloud.book.skill.facade;

import com.pcloud.book.skill.biz.PcloudSkillBiz;
import com.pcloud.book.skill.entity.PcloudSkill;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api("技能")
@RestController("pcloudSkillFacade")
@RequestMapping("pcloudSkill")
public class PcloudSkillFacade {

    @Autowired
    private PcloudSkillBiz pcloudSkillBiz;

    @ApiOperation("新增技能")
    @PostMapping("/createPcloudSkill")
    public ResponseDto<?> createPcloudSkill(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("技能模型") PcloudSkill pcloudSkill
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudSkillBiz.createPcloudSkill(pcloudSkill);
        return new ResponseDto<>();
    }

    @ApiOperation("修改技能")
    @PostMapping("/updatePcloudSkill")
    public ResponseDto<?> updatePcloudSkill(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("技能模型") PcloudSkill pcloudSkill
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudSkillBiz.updatePcloudSkill(pcloudSkill);
        return new ResponseDto<>();
    }

    @ApiOperation("获取技能")
    @GetMapping("/getPcloudSkill")
    public ResponseDto<?> getPcloudSkill(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("id") @ApiParam("技能模型") Long id
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudSkillBiz.getPcloudSkill(id));
    }

    @ApiOperation("获取技能列表")
    @GetMapping("/getPcloudSkillList")
    public ResponseDto<?> getPcloudSkillList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "skillType", required = false) @ApiParam("技能类型：1时间管理，2共读活动，3配套资料，4教辅书单，5配套老师，6音乐") Integer skillType,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称搜索")String name
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudSkillBiz.getPcloudSkillList(skillType,currentPage,numPerPage,name));
    }

    @ApiOperation("获取技能列表-关联关键词选择")
    @GetMapping("/getPcloudSkillList4Select")
    public ResponseDto<?> getPcloudSkillList4Select(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "skillType", required = false) @ApiParam("技能类型：1时间管理，2共读活动，3配套资料，4教辅书单，5配套老师，6音乐") Integer skillType,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称搜索")String name,
            @RequestParam(value = "depLabelId", required = false) @ApiParam("深度标签") Long depLabelId,
            @RequestParam(value = "proLabelId", required = false) @ApiParam("专业标签")Long proLabelId,
            @RequestParam(value = "purLabelId", required = false) @ApiParam("目的标签")Long purLabelId
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudSkillBiz.getPcloudSkillList4Select(skillType,currentPage,numPerPage,name,depLabelId,proLabelId,purLabelId));
    }

    @ApiOperation("删除技能")
    @GetMapping("/deletePcloudSkill")
    public ResponseDto<?> deletePcloudSkill(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("id") @ApiParam("技能模型") Long id
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudSkillBiz.deletePcloudSkill(id);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "订阅回复-H5", httpMethod = "GET")
    @GetMapping("/subscribePlan")
    public ResponseDto<?> subscribePlan( @RequestParam(value = "skillId", required = false) Long skillId,
                                  @RequestParam(value = "taskId", required = false) Integer taskId,
                                  @RequestParam(value = "robotWxId", required = false) String robotWxId,
                                  @RequestParam(value = "userWxId", required = false) String userWxId)
            throws BizException {
        return new ResponseDto<>(pcloudSkillBiz.setSubscribeState(skillId, taskId, robotWxId, userWxId, true));
    }

    @ApiOperation("修改技能")
    @PostMapping("/updateSeqNum")
    public ResponseDto<?> updateSeqNum(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("技能模型") PcloudSkill pcloudSkill
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudSkillBiz.updateSeqNum(pcloudSkill);
        return new ResponseDto<>();
    }
    @ApiOperation("获取技能基本信息")
    @GetMapping("/getPcloudSkillBaseInfoById")
    public ResponseDto<?> getPcloudSkillBaseInfoById(
            @RequestParam("id") @ApiParam("技能id") Long id
    ) throws BizException, PermissionException {
        return new ResponseDto<>(pcloudSkillBiz.getPcloudSkillBaseInfoById(id));
    }


}
