package com.pcloud.book.timecontrol.facade.impl;

import com.pcloud.book.timecontrol.biz.TaskBiz;
import com.pcloud.book.timecontrol.biz.TaskCompletedBiz;
import com.pcloud.book.timecontrol.biz.TaskSubscribeBiz;
import com.pcloud.book.timecontrol.dto.*;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @date: 2020年02月07日 12:52
 * @Author: zy
 * @Descprition
 */
@Api(value = "时间管理完成情况")
@RequestMapping(value = "/statis")
@RestController("statisFacade")
public class TimeControlStatisFacadeImpl {

    @Autowired
    private TaskBiz taskBiz;
    @Autowired
    private TaskSubscribeBiz taskSubscribeBiz;
    @Autowired
    private TaskCompletedBiz taskCompletedBiz;

    @GetMapping("listTaskCompleted4Pcloud")
    @ApiOperation(value = "平台端查询任务完成情况列表", httpMethod = "GET")
    ResponseDto<PageBeanNew<TaskCompletedDto>> listTaskCompleted4Pcloud(@RequestHeader("token") String token,
                                                                        @RequestParam Integer currentPage,
                                                                        @RequestParam Integer numPerPage,
                                                                        @RequestParam(value = "search", required = false) String search,
                                                                        @RequestParam(value = "taskName", required = false) String taskName,
                                                                        @RequestParam(value = "proLabelId", required = false) Integer proLabelId,
                                                                        @RequestParam(value = "depLabelId", required = false) Integer depLabelId,
                                                                        @RequestParam(value = "purLabelId", required = false) Integer purLabelId) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        PageBeanNew<TaskCompletedDto> pageResult = taskCompletedBiz.listTaskCompleted4Pcloud(currentPage, numPerPage, taskName,proLabelId,depLabelId,purLabelId);
        return new ResponseDto<>(pageResult);
    }

    @GetMapping("listTaskSubscribeUser4Pcloud")
    @ApiOperation(value = "平台端查询任务参与用户列表", httpMethod = "GET")
    ResponseDto<PageBeanNew<SubscribeTaskUserDTO>> listTaskSubscribeUser4Pcloud(@RequestHeader("token") String token,
                                                                                @RequestParam Integer currentPage,
                                                                                @RequestParam Integer numPerPage,
                                                                                @RequestParam(value = "taskId") Integer taskId,
                                                                                @RequestParam(value = "search", required = false) String search,
                                                                                @RequestParam(value = "subscribeType", required = false) Integer subscribeType) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        PageBeanNew<SubscribeTaskUserDTO> pageResult = taskCompletedBiz.listTaskSubscribeUser4Pcloud(currentPage, numPerPage, search,taskId,subscribeType);
        return new ResponseDto<>(pageResult);
    }

    @GetMapping("getTodayTaskSend")
    @ApiOperation(value = "获取今日消息发送信息", httpMethod = "GET")
    ResponseDto<TodayTaskSendDto> getTodayTaskSend(@RequestHeader("token") String token) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        TodayTaskSendDto todayTaskSendDto=taskCompletedBiz.getTodayTaskSend();
        return new ResponseDto<>(todayTaskSendDto);
    }

    @GetMapping("getTaskSendDateList")
    @ApiOperation(value = "获取有发送任务的日期集合", httpMethod = "GET")
    ResponseDto<List<String>> getTaskSendDateList(@RequestHeader("token") String token,
                                                  @RequestParam(value = "date") String date) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        List<String> taskSendDateList=taskCompletedBiz.getTaskSendDateList(date);
        return new ResponseDto<>(taskSendDateList);
    }

    @GetMapping("listTaskItemSendRecord4Pcloud")
    @ApiOperation(value = "平台端查询任务发送记录列表", httpMethod = "GET")
    ResponseDto<PageBeanNew<TaskItemSendDto>> listTaskItemSendRecord4Pcloud(@RequestHeader("token") String token,
                                                                            @RequestParam Integer currentPage,
                                                                            @RequestParam Integer numPerPage,
                                                                            @RequestParam(value = "startTime", required = false) String startTime,
                                                                            @RequestParam(value = "endTime", required = false) String endTime,
                                                                            @RequestParam(value = "robotWxId", required = false) String robotWxId,
                                                                            @RequestParam(value = "taskName", required = false) String taskName,
                                                                            @RequestParam(value = "sendContent", required = false) String sendContent,
                                                                            @RequestParam(value = "search", required = false) String search) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        PageBeanNew<TaskItemSendDto> pageResult = taskCompletedBiz.listTaskItemSendRecord4Pcloud(currentPage, numPerPage, startTime, endTime,robotWxId,taskName,sendContent,search);
        return new ResponseDto<>(pageResult);
    }

    @GetMapping("listTaskItemSendUser4Pcloud")
    @ApiOperation(value = "平台端查询任务发送读者详情列表", httpMethod = "GET")
    ResponseDto<PageBeanNew<TaskSendUserDto>> listTaskItemSendUser4Pcloud(@RequestHeader("token") String token,
                                                                          @RequestParam Integer currentPage,
                                                                          @RequestParam Integer numPerPage,
                                                                          @RequestParam(value = "taskItemId") Integer taskItemId,
                                                                          @RequestParam(value = "search", required = false) String search, @RequestParam String robotWxId) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        PageBeanNew<TaskSendUserDto> pageResult = taskCompletedBiz.listTaskItemSendUser4Pcloud(currentPage, numPerPage,taskItemId,search, robotWxId);
        return new ResponseDto<>(pageResult);
    }

    @GetMapping("getUserTaskProgress")
    @ApiOperation(value = "获取用户任务进度", httpMethod = "GET")
    ResponseDto<?> getUserTaskProgress(@RequestParam("wxUserId") String wxUserId, @RequestParam("taskId") Integer taskId)
            throws PermissionException, BizException {
        return new ResponseDto<>(taskCompletedBiz.getUserTaskProgress(taskId, wxUserId));
    }
}