package com.pcloud.book.weixinclock.biz;

import com.pcloud.book.weixinclock.dto.ListWeixinClockRankDto;
import com.pcloud.book.weixinclock.dto.RankDto;
import com.pcloud.book.weixinclock.vo.request.PraiseForMemberRequestVO;
import com.pcloud.book.weixinclock.vo.response.ListPraiseUserResponseVO;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

import java.util.List;

/**
 * @Describe: 微信打卡点赞逻辑层
 * @Author: zhangdongwei
 * @Date: Create on 9:10 2019/10/23 0023
 */
public interface WeixinClockPraiseBiz {
    /**
     * 为打卡成员点赞/取消点赞
     * @param vo
     */
    void praiseForMember(PraiseForMemberRequestVO vo);

    /**
     * 填充打卡排行榜点赞信息
     * @param list
     * @param listWeixinClockRankDto
     */
    void fillPraise(List<RankDto> list, ListWeixinClockRankDto listWeixinClockRankDto);

    /**
     * 获取点赞用户列表
     * @param wxGroupId
     * @param wxUserId
     * @return
     */
    PageBeanNew<ListPraiseUserResponseVO> listPraiseUser(String wxGroupId, String wxUserId, PageParam pageParam);
}
