package com.pcloud.book.weixinclock.vo.request;

import com.pcloud.book.weixinclock.entity.WeixinClockPraise;
import com.pcloud.common.utils.bean.BeanUtils;
import com.pcloud.common.vo.BaseVO;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Describe: 为打卡成员点赞请求vo
 * @Author: zhangdongwei
 * @Date: Create on 17:57 2019/10/22 0022
 */
@Data
@ApiModel("为打卡成员点赞请求类")
public class PraiseForMemberRequestVO extends BaseVO {
    /**
     * 点赞人id
     */
    private Long praiseUserId;
    /**
     * 打卡成员id
     */
    @NotNull(message = "打卡成员不能为空")
    @ApiModelProperty("打卡成员id")
    private String wxUserId;
    /**
     * 群id
     */
    @NotNull(message = "群id不能为空")
    @ApiModelProperty("打卡关联微信群id")
    private String wxGroupId;

    @ApiModelProperty("是否取消点赞")
    private Integer isCancel;

    public static WeixinClockPraise valueToClockPraise(PraiseForMemberRequestVO vo){
        WeixinClockPraise weixinClockPraise = BeanUtils.copy(vo, WeixinClockPraise.class);
        weixinClockPraise.setIsCancel(vo.getIsCancel() == null ? 0 : vo.getIsCancel());
        return weixinClockPraise;
    }
}
