package com.pcloud.book.base.enums;

/**
 *  图书版权保护状态状态
 */
public enum BookStatusEnum {
    /**
     * 保护中
     */
    PROTECT(1),
    /**
     * 否
     */
    NO_SET(0);

    /**
     * 值
     */
    public final Integer value;

    /**
     * 构造
     *
     * @param value
     */
    BookStatusEnum(Integer value) {
        this.value = value;
    }

    /**
     * 验证方式
     */
    public enum AuthCodeTypeEnum{

        /**
         * 授权码
         */
        BY_CODE(0),

        /**
         * 授权金
         */
        BY_PAY(1);

        public final Integer value;

        /**
         * 构造
         *
         * @param value
         */
        AuthCodeTypeEnum(Integer value) {
            this.value = value;
        }
    }

    /**
     * 验证码状态值
     */
    public enum CodeUseTypeEnum{

        /**
         * 已经被使用
         */
        HAVE_USE(0),

        /**
         * 正确
         */
        RIGHT(1),

        /**
         * 不正确
         */
        NOT_RIGHT(2),
        /**
         * 满了
         */
        FULL(3);

        public final Integer value;

        /**
         * 构造
         *
         * @param value
         */
        CodeUseTypeEnum(Integer value) {
            this.value = value;
        }
    }

    public enum BookDeleteStatus{

        /**
         * 已删除
         */
        DELETE(1),

        /**
         * 未删除
         */
        NOT_DELETE(0);

        public final Integer value;

        /**
         * 构造
         *
         * @param value
         */
        BookDeleteStatus(Integer value) {
            this.value = value;
        }
    }

    public enum BookExportStatus{

        /**
         * 进行中
         */
        ON(0),

        /**
         * 已完成
         */
        SUCCESS(1),

        /**
         * 失败
         */
        FAIL(2);

        public final Integer value;

        /**
         * 构造
         *
         * @param value
         */
        BookExportStatus(Integer value) {
            this.value = value;
        }
    }
}
