package com.pcloud.book.book.service;

import com.pcloud.common.dto.ResponseDto;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

import io.swagger.annotations.Api;

@FeignClient(value = "pcloud-service-book", qualifiers = "bookServiceCloud", path = "book/v1.0/keywordService")
@Api(description = "书籍关键词内部服务")
public interface KeywordService {

    @GetMapping("getKeywordByWxGroupId")
    ResponseEntity<ResponseDto<List<String>>> getKeywordByWxGroupId(@RequestParam("wxGroupId") String wxGroupId);

}
