package com.pcloud.book.group.enums;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/25 15:05
 **/
public enum JoinGroupTypeEnum {
    /**
     * 群二维码
     */
    GROUP_QRCODE(1, "群二维码"),

    /**
     * 客服机器人
     */
    ROBOT(2, "客服机器人"),

    /**
     * AI客服机器人
     */
    AI_ROBOT(3, "AI客服机器人"),

    /**
     * 小睿机器人
     */
    XIAORUI(4,"小睿机器人");

    private final Integer code;

    private final String name;

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    private JoinGroupTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getBookTypeName(Integer code){
        if(JoinGroupTypeEnum.XIAORUI.getCode().equals(code)){
            return "小睿书";
        } else if(JoinGroupTypeEnum.ROBOT.getCode().equals(code) || JoinGroupTypeEnum.AI_ROBOT.getCode().equals(code)){
            return "1V1";
        } else if(JoinGroupTypeEnum.GROUP_QRCODE.getCode().equals(code)){
            return "微信群";
        }
        return null;
    }
}
