package com.pcloud.book.personlstage.service;

import com.pcloud.book.personlstage.dto.UserReplaceCodeDTO;
import com.pcloud.common.dto.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifiers = "personalStageServiceCloud", path = "book/v1.0/personalStageService")
@Api("阶段内部接口")
public interface PersonalStageService {

    @ApiOperation("根据小号类别获取小号")
    @PostMapping("createUserReplaceCode")
    void createUserReplaceCode(@RequestBody @ApiParam("方案阶段跳转") UserReplaceCodeDTO userReplaceCodeDTO);

}
