package com.pcloud.book.advertising.check;

import com.pcloud.book.advertising.entity.AdvertisingCpa;
import com.pcloud.book.advertising.entity.AdvertisingDetailFile;
import com.pcloud.book.advertising.entity.AdvertisingSpace;
import com.pcloud.book.advertising.enums.AdDetailModeEnum;
import com.pcloud.book.advertising.enums.AdPositionDetailEnum;
import com.pcloud.book.advertising.enums.AdPositionEnum;
import com.pcloud.book.advertising.enums.AdPositionModeEnum;
import com.pcloud.book.advertising.enums.SettlementMethodEnum;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @描述：广告位参数校验
 * @作者：zhuyajie
 * @创建时间：11:15 2019/9/4
 * @版本：1.0
 */
@Component("advertisingCheck")
public class AdvertisingCheck {

    /**
     * 新增广告位前校验参数
     */
    public void checkParamBeforeCreate(AdvertisingSpace advertisingSpace) {
        String adPosition = advertisingSpace.getAdPosition();
        if (null == advertisingSpace.getAdName() ||  null == advertisingSpace.getMasterId() || null == advertisingSpace.getSettlementMethod()) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数有误！");
        }
       /* if (!AdPositionEnum.checkCodeExist(adPosition)) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "广告位置选择有误！");
        }
        if (!AdPositionModeEnum.checkCodeExist(adPosition, advertisingSpace.getAdPositionMode())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "广告位置选择有误！");
        }
        if (AdPositionEnum.BOOK_GROUP_PAGE.equals(adPosition)
                && !AdPositionDetailEnum.checkCodeExist(adPosition, advertisingSpace.getAdPositionDetail())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "广告位置选择有误！");
        }*/
        String settlementMethod = advertisingSpace.getSettlementMethod();
        //按点击量结算、按曝光量结算、按实际行动结算价格不为空
        if (ArrayUtils.contains(SettlementMethodEnum.SETTLEMENT_METHOD_NEED_PRICE_GATHER, settlementMethod)
                && null == advertisingSpace.getPriceEachTime()) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "价格不能为空！");
        }
    }

    /**
     * CPA方式参数校验
     * @param advertisingCpa
     */
    public void checkCPAParam(AdvertisingCpa advertisingCpa) {
        List<AdvertisingDetailFile> fileList = advertisingCpa.getAdvertisingDetailFileList();
        if (StringUtil.isEmpty(advertisingCpa.getDetailMode())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "广告详情不能为空！");
        }
        if (ListUtils.isEmpty(advertisingCpa.getAdvertisingBmOptionList())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "报名表单不能为空！");
        }
        if (StringUtil.isEmpty(advertisingCpa.getDetailInfo())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "产品介绍不能为空！");
        }
//        if (StringUtil.isEmpty(advertisingCpa.getWelfarePic())) {
//            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "优惠展示图不能为空！");
//        }
        //1图文介绍
        if (AdDetailModeEnum.IMG_TEXT.code.equals(advertisingCpa.getDetailMode())) {
            if (StringUtil.isEmpty(advertisingCpa.getCoverPic())) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "封面不能为空！");
            }
        }
        //2音频试听
        else if (AdDetailModeEnum.AUDIO.code.equals(advertisingCpa.getDetailMode())) {
            if (ListUtils.isEmpty(fileList)) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "请上传音频资源！");
            }
            for (AdvertisingDetailFile file : fileList) {
                if (StringUtil.isEmpty(file.getFileId())) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "请上传音频资源！");
                }
                if (StringUtil.isEmpty(file.getTitle())) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "标题不能为空！");
                }
            }
        }
        //3视频试看
        else if (AdDetailModeEnum.VIDEO.code.equals(advertisingCpa.getDetailMode())) {
            if (ListUtils.isEmpty(fileList)) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "请上传视频资源！");
            }
            for (AdvertisingDetailFile file : fileList) {
                if (StringUtil.isEmpty(file.getCoverPic())) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "封面不能为空！");
                }
                if (StringUtil.isEmpty(file.getFileId())) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "请上传视频资源！");
                }
                if (StringUtil.isEmpty(file.getTitle())) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "标题不能为空！");
                }
            }
        }
        //报名设置
        if (null == advertisingCpa.getFormMobileCheck()) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "手机号校验不能为空！");
        }
        if (StringUtil.isEmpty(advertisingCpa.getFormRemark())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "报名表单备注不能为空！");
        }
        if (StringUtil.isEmpty(advertisingCpa.getFormButton())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "按钮提示不能为空！");
        }
    }

    /**
     * 判断链接文本长度
     * @param adTitle
     */
    /*public void checkLinkLength(String adTitle){
        List<String> linkList = getLinkList(adTitle);
        int linkLength = 0;//短链接长度
        if (!ListUtils.isEmpty(linkList)) {
            for (String link : linkList) {
                adTitle = adTitle.replace(link, "");
                linkLength = linkLength + 26;
            }
        }
        int length = linkLength + adTitle.length();
        if (length > 300) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "文本长度超过300！");
        }
    }*/

/*    private List<String> getLinkList(String title) {
        List<String> list = new ArrayList<>();
        Pattern pa = Pattern.compile("<link>.*?</link>");//标题正则表达式
        Matcher ma = pa.matcher(title);
        while (ma.find()) {
            list.add(ma.group());
        }
        return list;
    }*/
}
