package com.pcloud.book.advertising.dao;

import java.util.List;
import com.pcloud.book.advertising.dto.AdvertisingSettlementMethodDTO;
import com.pcloud.book.advertising.entity.AdvertisingSettlementMethod;
import com.pcloud.common.core.dao.BaseDao;

/**
 * Description 广告结算方式数据访问层接口
 * Created by PENG on 2019/4/26.
 */
public interface AdvertisingSettlementMethodDao extends BaseDao<AdvertisingSettlementMethod> {

    /**
     * 删除广告主配置的结算方式
     * @param masterId 广告主ID
     * @return
     */
    long deleteByMasterId(Long masterId);

    /**
     * 获取广告主配置的结算方式列表
     * @param masterId 广告主ID
     * @return
     */
    List<AdvertisingSettlementMethodDTO> getByMasterId(Long masterId);

    /**
     * 获取广告位的结算方式
     * @param masterId 广告主ID
     * @param adId     广告位ID
     * @return
     */
    AdvertisingSettlementMethodDTO getByMasterIdAndAdId(Long masterId, Long adId);

    List<AdvertisingSettlementMethodDTO> getByMasterIdsAndAdIds(List<Long> masterIds, List<Long> adIds);
}
