package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletRecordStatisReportDTO;
import com.pcloud.book.applet.entity.AppletRecordStatisReport;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;

/**
 * 个人阅读报告总结(AppletRecordStatisReport)表服务接口
 *
 * @author makejava
 * @since 2020-12-11 16:22:46
 */
public interface AppletRecordStatisReportBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletRecordStatisReport getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param appletRecordStatisReport 实例对象
     * @return 主键
     */
    Long insert(AppletRecordStatisReport appletRecordStatisReport);

    /**
     * 修改数据
     *
     * @param appletRecordStatisReport 实例对象
     */
    void update(AppletRecordStatisReport appletRecordStatisReport);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    AppletRecordStatisReport getReadReport4Week(Long wechatUserId, String mondayDate);

    PageBeanNew getReadReportList(Long wechatUserId, Integer currentPage, Integer numPerPage);

    String shareReadReport(Long wechatUserId, String mondayDate);
}
