package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.AppletBookIgnorBiz;
import com.pcloud.book.applet.dao.AppletBookIgnorDao;
import com.pcloud.book.applet.entity.AppletBookIgnor;
import com.pcloud.book.book.biz.BookBiz;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.consumer.user.AdviserConsr;
import com.pcloud.book.rightsSetting.entity.RightsSettingBookRelation;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import com.pcloud.usercenter.party.adviser.dto.AdviserBaseInfoDto;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.pcloud.book.book.constant.BookConstant.IGNOR_BOOK_KEY;

/**
 * (AppletBookIgnor)表服务实现类
 *
 * @author makejava
 * @since 2021-05-06 13:49:59
 */
@Service("appletBookIgnorBiz")
public class AppletBookIgnorBizImpl implements AppletBookIgnorBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletBookIgnorBizImpl.class);

    @Autowired
    private AppletBookIgnorDao appletBookIgnorDao;
    @Autowired
    private AdviserConsr adviserConsr;
    @Autowired
    private BookBiz bookBiz;
    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletBookIgnor getById(Long id) {
        return appletBookIgnorDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletBookIgnorDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据
        fillBookInfo(recordList);
        return pageBeanNew;
    }

    private void fillBookInfo(List<AppletBookIgnor> recordList) {
        List<Long> bookIds = recordList.stream().map(e -> e.getBookId()).collect(Collectors.toList());
        List<Long> adviserIds = recordList.stream().map(e -> e.getAdviserId()).collect(Collectors.toList());
        Map<Long, AdviserBaseInfoDto> infoDtoMap = adviserConsr.getAdviserId2AdviserInfoDtoMap(adviserIds);
        Map<Long, BookDto> bookDtoMap = bookBiz.getListByIds(bookIds);
        if (MapUtils.isEmpty(bookDtoMap)) {
            return;
        }
        for (AppletBookIgnor appletBookIgnor: recordList) {
            if (bookDtoMap.containsKey(appletBookIgnor.getBookId()) && null != bookDtoMap
                    .get(appletBookIgnor.getBookId())) {
                appletBookIgnor.setBookName(bookDtoMap.get(appletBookIgnor.getBookId()).getBookName());
                appletBookIgnor.setIsbn(bookDtoMap.get(appletBookIgnor.getBookId()).getIsbn());
                appletBookIgnor.setCoverImg(bookDtoMap.get(appletBookIgnor.getBookId()).getCoverImg());
            }
            if (MapUtils.isNotEmpty(infoDtoMap) && null != infoDtoMap.get(appletBookIgnor.getAdviserId())) {
                if (null != infoDtoMap.get(appletBookIgnor.getAdviserId())) {
                    appletBookIgnor.setAdviserName(infoDtoMap.get(appletBookIgnor.getAdviserId()).getPartyName());
                    appletBookIgnor.setAgentName(infoDtoMap.get(appletBookIgnor.getAdviserId()).getAgentName());
                }
            }
        }
    }

    @Override
    @ParamLog("新增")
    public Long insert(AppletBookIgnor appletBookIgnor) {
        if (null == appletBookIgnor || null == appletBookIgnor.getBookId()) {
            throw new BizException(BizException.PARAM_IS_NULL.getCode(),"书籍id为空");
        }
        List<Long> allIgnorBookIds = appletBookIgnorDao.getAllIgnorBookIds();
        if (!ListUtils.isEmpty(allIgnorBookIds) && allIgnorBookIds.contains(appletBookIgnor.getBookId())) {
            throw new BizException(BizException.PARAM_IS_NULL.getCode(),"请勿重复添加书籍");
        }
        JedisClusterUtils.del(IGNOR_BOOK_KEY);
        appletBookIgnorDao.insert(appletBookIgnor);
        return appletBookIgnor.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletBookIgnor appletBookIgnor) {
        if (appletBookIgnor == null || !NumberUtil.isNumber(appletBookIgnor.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        JedisClusterUtils.del(IGNOR_BOOK_KEY);
        appletBookIgnorDao.update(appletBookIgnor);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletBookIgnorDao.deleteById(id);
    }

    @Override
    @ParamLog("软删除")
    public void softDeleteById(Long id) {
        JedisClusterUtils.del(IGNOR_BOOK_KEY);
        appletBookIgnorDao.softDeleteById(id);
    }

    @Override
    @ParamLog("获取所有被屏蔽的书籍ids")
    public List<Long> getAllIgnorBookIds() {
        List<Long> ignorBookIds = appletBookIgnorDao.getAllIgnorBookIds();
        return ListUtils.isEmpty(ignorBookIds) ? new ArrayList<>() : ignorBookIds;
    }
}