package com.pcloud.book.applet.biz.impl;

import cn.hutool.core.collection.CollUtil;
import com.pcloud.book.applet.entity.AppletSubscribeSend;
import com.pcloud.book.applet.dao.AppletSubscribeSendDao;
import com.pcloud.book.applet.biz.AppletSubscribeSendBiz;
import com.pcloud.book.consumer.reader.ReaderConsr;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * (AppletSubscribeSend)表服务实现类
 *
 * @author wubo 
 * @since 2022-05-24 15:59:27
 */
@Service("appletSubscribeSendBiz")
public class AppletSubscribeSendBizImpl implements AppletSubscribeSendBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletSubscribeSendBizImpl.class);

    @Autowired
    private AppletSubscribeSendDao appletSubscribeSendDao;
    @Autowired
    private ReaderConsr readerConsr;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletSubscribeSend getById(Long id) {
        return appletSubscribeSendDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletSubscribeSendDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(AppletSubscribeSend appletSubscribeSend) {
        appletSubscribeSendDao.insert(appletSubscribeSend);
        return appletSubscribeSend.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletSubscribeSend appletSubscribeSend) {
        if(appletSubscribeSend == null || !NumberUtil.isNumber(appletSubscribeSend.getId())){
            throw BizException.PARAM_IS_NULL;
        }
        appletSubscribeSendDao.update(appletSubscribeSend);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletSubscribeSendDao.deleteById(id);
    }
    
    @Override
    @ParamLog("软删除")
    public void softDeleteById(Long id) {
     appletSubscribeSendDao.softDeleteById(id);
    }

    @Override
    public void subscribeSend() {
        List<Long> userIds = appletSubscribeSendDao.getAllUserIds();
        if (CollUtil.isEmpty(userIds)) {
            return;
        }
        userIds.stream().forEach(wechatUserId -> {
            readerConsr.subscribeSend(wechatUserId);
        });
    }

}
