package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.HotBookSaleBiz;
import com.pcloud.book.applet.dao.HotBookSaleDao;
import com.pcloud.book.applet.entity.HotBookSale;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.entity.HotBook;
import com.pcloud.book.consumer.user.AdviserConsr;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.usercenter.party.adviser.dto.AdviserBaseInfoDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 热门书名(HotBookSale)表服务实现类
 *
 * @author makejava
 * @since 2020-10-14 12:06:59
 */
@Service("hotBookSaleBiz")
public class HotBookSaleBizImpl implements HotBookSaleBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(HotBookSaleBizImpl.class);

    @Autowired
    private HotBookSaleDao hotBookSaleDao;
    @Autowired
    private AdviserConsr adviserConsr;


    @Override
    @ParamLog("通过ID查询单条数据")
    public HotBookSale getById(Integer id) {
        return hotBookSaleDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = hotBookSaleDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Integer insert(HotBookSale hotBook) {
        if (hotBook==null|| hotBook.getBookId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"热门书不能为空！");
        }
        Integer maxSeqNum=hotBookSaleDao.getMaxSeqNum();
        hotBook.setSeqNum(maxSeqNum+1);
        hotBookSaleDao.insert(hotBook);
        hotBookSaleDao.insert(hotBook);
        return hotBook.getId().intValue();
    }

    @Override
    @ParamLog("修改")
    public void update(HotBookSale hotBookSale) {
        if (hotBookSale == null || !NumberUtil.isNumber(hotBookSale.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        hotBookSaleDao.update(hotBookSale);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Integer id) {
        hotBookSaleDao.deleteById(id);
    }

    @Override
    public PageBeanNew<HotBookSale> getHotBookList(Integer currentPage, Integer numPerPage) {
        if (currentPage==null||currentPage<0||numPerPage==null||numPerPage<=0){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"分页参数有误！");
        }
        PageBeanNew<HotBookSale> pageNew = hotBookSaleDao.listPageNew(new PageParam(currentPage, numPerPage), new HashMap<>(), "getHotBookList");
        List<HotBookSale> list=pageNew.getRecordList();
        //填充出版社信息
        fillHotBookAgent(list);
        return pageNew;
    }

    private void fillHotBookAgent(List<HotBookSale> list) {
        if (ListUtils.isEmpty(list)){
            return;
        }
        List<Long> adviserIds=list.stream().filter(s->s.getAdviserId()!=null).map(HotBookSale::getAdviserId).distinct().collect(Collectors.toList());
        if (ListUtils.isEmpty(adviserIds)){
            return;
        }
        Map<Long, AdviserBaseInfoDto> infoDtoMap = adviserConsr.getAdviserId2AdviserInfoDtoMap(adviserIds);
        for (HotBookSale hotBook:list){
            AdviserBaseInfoDto infoDto = infoDtoMap.get(hotBook.getAdviserId());
            if (infoDto!=null){
                hotBook.setAgentId(infoDto.getAgentId());
                hotBook.setAgentName(infoDto.getAgentName());
            }
        }
    }
}