package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.entity.AppletRecordDayServe;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * (AppletRecordDayServe)表数据库访问层
 *
 * @author makejava
 * @since 2020-12-09 16:04:08
 */
public interface AppletRecordDayServeDao extends BaseDao<AppletRecordDayServe> {

    /**
     * 查询数据是否存在
     * @param wechatUserId
     * @param recordType
     * @param fromId
     * @param today
     * @return
     */
    AppletRecordDayServe getByTypeAndServeId(Long wechatUserId, Integer recordType, Long fromId, String today);

    Map<Long, AppletUserBookcaseDTO> getBookMap(List<AppletRecordDTO> appletRecordDTOS4Book);

    List<AppletRecordDTO> getAppletRecordCatalogue(Map<String, Object> paramMap);

    /**
     * 批量更新
     * @param recordList
     */
    void batchUpdate(List<AppletRecordDTO> recordList);
}