package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.HotBookSaleDao;
import com.pcloud.book.applet.entity.HotBookSale;
import com.pcloud.book.book.entity.HotBook;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 热门书名(HotBookSale)表数据库访问层
 *
 * @author makejava
 * @since 2020-10-14 12:06:58
 */
@Repository("hotBookSaleDaoImpl")
public class HotBookSaleDaoImpl extends BaseDaoImpl<HotBookSale> implements HotBookSaleDao {

    @Override
    public Integer getMaxSeqNum() {
        return super.getSqlSession().selectOne(super.getStatement("getMaxSeqNum"));
    }

    @Override
    public void updateSeqNum(Long id, Integer seqNum) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        map.put("seqNum",seqNum);
        super.getSqlSession().update(super.getStatement("updateSeqNum"),map);
    }

    @Override
    public List<HotBookSale> getHotBookList() {
        return  super.getSqlSession().selectList(super.getStatement("getHotBookList"));
    }
}