package com.pcloud.book.applet.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 小睿小程序点击量统计(AppletRecordStatis)实体类
 *
 * @author makejava
 * @since 2020-12-10 18:03:37
 */
@Data
public class AppletRecordStatis extends BaseEntity {

    private static final long serialVersionUID = -47890081209136384L;
    
    @ApiModelProperty("主键id")
    private Long id;
    
    @ApiModelProperty("用户id")
    private Long wechatUserId;
    
    @ApiModelProperty("记录类型")
    private Integer recordType;
    
    @ApiModelProperty("应用/作品类型/资源类型")
    private String sourceType;
    
    @ApiModelProperty("点击量")
    private Long clickCount;
    
    @ApiModelProperty("统计日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date statisDate;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    
    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    
}
