package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletBookScoreBiz;
import com.pcloud.book.applet.dto.AppletBookUserScoreDTO;
import com.pcloud.book.applet.dto.AppletFeedbackDTO;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.channelcenter.base.exceptions.ChannelBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.Objects;

@Api(tags = "小程序本服务用户评价相关接口")
@RestController
@Slf4j
@RequestMapping("/appletBookScore")
public class AppletBookScoreFacade {
    @Autowired
    private AppletBookScoreBiz appletBookScoreBiz;

    @ApiOperation(value = "上传图片获取二维码信息", httpMethod = "POST")
    @PostMapping("/uploadFile")
    ResponseDto<?> uploadFile(@RequestParam(value = "file") MultipartFile[] file)
            throws PermissionException, BizException {
        if (file.length < 1) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "上传失败，请选择文件！");
        }
        return new ResponseDto<>(appletBookScoreBiz.uploadFile(file));
    }

    @ApiOperation("新增小程序本服务评价")
    @GetMapping("/add")
    ResponseDto<Long> add(@CookieValue("userInfo") String userInfo,
                          @RequestParam("bookId") Long bookId,
                          @RequestParam("channelId") Long channelId,
                          @RequestParam("adviserId") Long adviserId,
                          @RequestParam("tagId") Long tagId,
                          @RequestParam("subTagId") Long subTagId
                          ) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletBookScoreBiz.score(wechatUserId, bookId, channelId, adviserId, tagId, subTagId));
    }


    @GetMapping("/get")
    ResponseDto<List<AppletBookUserScoreDTO>> get(@CookieValue("userInfo") String userInfo,
                                                  @RequestParam("bookId") Long bookId,
                                                  @RequestParam("channelId") Long channelId,
                                                  @RequestParam("adviserId") Long adviserId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletBookScoreBiz.get(wechatUserId, bookId, channelId, adviserId));
    }

    @PostMapping("/feedback")
    ResponseDto<Void> feedback(@CookieValue("userInfo") String userInfo, @RequestBody AppletFeedbackDTO feedbackDTO){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletBookScoreBiz.feedback(wechatUserId, feedbackDTO));
    }

    @GetMapping("/export")
    void export(HttpServletResponse response) {
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            // 指定下载文件名称
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode("本书服务评价数据导出.xlsx", "UTF-8"));
            // 指定下载文件类型
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            outputStream.write(appletBookScoreBiz.export());
            outputStream.flush();
            outputStream.close();
        } catch (Exception e) {
            log.warn("[AppletBookScoreFacade.export] 数据导出失败！", e);
        }
    }
}
