package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.ServeCollectBiz;
import com.pcloud.book.applet.dto.CollectionTypeNameAndCountDTO;
import com.pcloud.book.applet.entity.ServeCollect;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * (ServeCollect)表控制层
 *
 * @author makejava
 * @since 2020-09-10 10:44:31
 */
@RestController("serveCollectFacade")
@RequestMapping("serveCollect")
public class ServeCollectFacade {

    @Autowired
    private ServeCollectBiz serveCollectBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@CookieValue("userInfo") String userInfo, @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(serveCollectBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@CookieValue("userInfo") String userInfo,
                                  @RequestParam(value = "typeCode",required = false) String typeCode,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(serveCollectBiz.getList(wechatUserId, currentPage, numPerPage, typeCode, officialAccountsId));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@CookieValue("userInfo") String userInfo, @RequestBody ServeCollect serveCollect)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>();
    }

    @ApiOperation("收藏")
    @PostMapping("collect")
    public ResponseDto<?> collect(@CookieValue("userInfo") String userInfo, @RequestBody ServeCollect serveCollect)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        serveCollect.setWechatUserId(wechatUserId);
        return new ResponseDto<>(serveCollectBiz.insert(serveCollect));
    }


    @ApiOperation("取消收藏")
    @PostMapping("cancel")
    public ResponseDto<?> cancel(@CookieValue("userInfo") String userInfo, @RequestBody ServeCollect serveCollect)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        serveCollect.setWechatUserId(wechatUserId);
        serveCollectBiz.cancel(serveCollect);
        return new ResponseDto<>();
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@CookieValue("userInfo") String userInfo, @RequestBody ServeCollect serveCollect) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        serveCollectBiz.update(serveCollect);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@CookieValue("userInfo") String userInfo, @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        serveCollectBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("取消收藏")
    @PostMapping("cancelCollect")
    public ResponseDto<?> cancelCollect(@CookieValue("userInfo") String userInfo, @RequestBody List<Long> ids) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (ListUtils.isEmpty(ids)) {
            throw BookBizException.PARAM_DELETION;
        }
        serveCollectBiz.cancelCollect(ids);
        return new ResponseDto<>();
    }

    @ApiOperation("获取所有的收藏id")
    @GetMapping("getAllCollect")
    public ResponseDto<?> getAllCollect(@CookieValue("userInfo") String userInfo,
                                        @RequestParam(value = "typeCode",required = false) String typeCode) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        List<Long> ids = serveCollectBiz.getAllCollect(wechatUserId,typeCode, officialAccountsId);
        return new ResponseDto<>(ListUtils.isEmpty(ids) ? new ArrayList<>() : ids);
    }

    @ApiOperation("获取用户收藏种类名称及其个数")
    @GetMapping("getTypeNameAndCountByWechatUserId")
    public  ResponseDto<List<CollectionTypeNameAndCountDTO>> getTypeNameAndCountByWechatUserId(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        List<CollectionTypeNameAndCountDTO> typeNameAndCountByWechatId = serveCollectBiz.getTypeNameAndCountByWechatId(wechatUserId, officialAccountsId);
        return new ResponseDto<>(ListUtils.isEmpty(typeNameAndCountByWechatId) ? new ArrayList<>() : typeNameAndCountByWechatId);
    }


    @ApiOperation("根据类别名称的收藏")
    @GetMapping("getListByTypeNameAndWechatUserId")
    public ResponseDto<?> getListByTypeNameAndWechatUserId(@CookieValue("userInfo") String userInfo,
                                                           @RequestParam("typeName") String typeName,
                                                           @RequestParam(value = "currentPage",defaultValue = "0") Integer currentPage,
                                                           @RequestParam(value = "numPerPage",defaultValue = "10") Integer numPerPage ){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(serveCollectBiz.getListByTypeNameAndWechatUserId(typeName,wechatUserId,currentPage,numPerPage));
    }

    @ApiOperation("查询单条资讯是否被收藏")
    @GetMapping("isCollected")
    public ResponseDto<?> isCollected (@CookieValue("userInfo") String userInfo,
                                       @RequestParam("serverId") Long serverId){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(serveCollectBiz.isCollected(wechatUserId,serverId));
    }

    @ApiOperation("填充TypeName")
    @GetMapping("processingData")
    public ResponseDto<?> processingData(@RequestHeader("token") @ApiParam("token") String token){
        SessionUtil.getInfoToken4Redis(token);
        serveCollectBiz.processingData();
        return new ResponseDto<>();
    }

    @ApiOperation("填充收藏TypeCode与TypeName")
    @GetMapping("processingData2TypeCode")
    public ResponseDto<?> processingData2TypeCode(@RequestHeader("token") String token){
        SessionUtil.getToken4Redis(token);
        serveCollectBiz.processingData2TypeCode();
        return new ResponseDto<>();
    }

    @ApiOperation("查询应用作品收藏状态")
    @GetMapping("getCollectState")
    public ResponseDto<?> getCollectState(@CookieValue("userInfo") String userInfo,
                                          @RequestParam(value = "serverId", required = false) Long serverId,
                                          @RequestParam("serveType") Integer serveType) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (Objects.isNull(serverId)) {
            return new ResponseDto<>(false);
        }
        return new ResponseDto<>(serveCollectBiz.getCollectState(wechatUserId, serverId, serveType));
    }
}