package com.pcloud.book.book.facade;

import com.pcloud.book.book.entity.HotBook;
import com.pcloud.book.book.entity.SearchRecord;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

@Api("书籍搜索")
public interface SearchFacade {

    @ApiOperation("创建热门书")
    @PostMapping("createHotBook")
    ResponseDto<?> createHotBook(
            @RequestHeader("token") String token,
            @RequestBody HotBook hotBook
    ) throws PermissionException;

    @ApiOperation("删除热门书")
    @GetMapping("deleteHotBook")
    ResponseDto<?> deleteHotBook(
            @RequestHeader("token") String token,
            @RequestParam("id") Long id
    ) throws PermissionException;

    @ApiOperation("获取热门书PC")
    @GetMapping("getHotBookList4PC")
    ResponseDto<?> getHotBookList4PC(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("获取热门书H5")
    @GetMapping("getHotBookList4H5")
    ResponseDto<?> getHotBookList4H5(
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("修改热门书排序值")
    @PostMapping("updateHotBookSeqNum")
    ResponseDto<?> updateHotBookSeqNum(
            @RequestHeader("token") String token,
            @RequestBody HotBook hotBook
    ) throws PermissionException;

    @ApiOperation("创建搜索记录H5")
    @PostMapping("createSearchRecord4H5")
    ResponseDto<?> createSearchRecord4H5(
        @CookieValue(value = "userInfo") String  userInfo,
            @RequestBody SearchRecord searchRecord
    ) throws PermissionException;

    @ApiOperation("获取热门搜索列表")
    @GetMapping("getSearchList")
    ResponseDto<?> getSearchList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "content" ,required = false) @ApiParam("内容") String content,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("导出热门搜索列表")
    @GetMapping("exportSearchList")
    ResponseDto<?> exportSearchList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "content" ,required = false) @ApiParam("内容") String content
    ) throws BizException, PermissionException;

    @ApiOperation("获取某个热门搜索列表")
    @GetMapping("getSearchRecordList")
    ResponseDto<?> getSearchRecordList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("content" ) @ApiParam("内容") String content,
            @RequestParam(value = "bookId", required = false) @ApiParam("书id") Long bookId,
            @RequestParam(value = "agentId", required = false) @ApiParam("出版社id") Long agentId,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("导出某个热门搜索列表")
    @GetMapping("exportSearchRecordList")
    ResponseDto<?> exportSearchRecordList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("content" ) @ApiParam("内容") String content,
            @RequestParam(value = "bookId", required = false) @ApiParam("书id") Long bookId,
            @RequestParam(value = "agentId", required = false) @ApiParam("出版社id") Long agentId
    ) throws BizException, PermissionException;

    @ApiOperation("获取用户最近搜索列表H5")
    @GetMapping("getUserSearchList4H5")
    ResponseDto<?> getUserSearchList4H5(
            @CookieValue(value = "userInfo") String  userInfo,
            @RequestParam(value = "wxId", required = false) @ApiParam("用户id") String wxId,
            @RequestParam(value = "wechatUserId", required = false) @ApiParam("微信id") Long wechatUserId,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("删除用户搜索记录H5")
    @GetMapping("deleteUserSearchList4H5")
    ResponseDto<?> deleteUserSearchList4H5(
            @RequestParam(value = "wxId", required = false) @ApiParam("用户id") String wxId,
            @RequestParam(value = "wechatUserId", required = false) @ApiParam("微信id") Long wechatUserId
    ) throws BizException, PermissionException;

    @ApiOperation("获取搜索书籍的用户H5")
    @GetMapping("getBookSearchUserList4H5")
    ResponseDto<?> getBookSearchUserList4H5(
            @RequestParam("bookId" ) @ApiParam("书id") Long bookId
    ) throws BizException, PermissionException;

    @ApiOperation("获取用户搜索书籍前几")
    @GetMapping("getBookSearchTop")
    ResponseDto<?> getBookSearchTop(
            @RequestParam("top" ) @ApiParam("前几") Integer top
    ) throws BizException, PermissionException;

}
