/**
 * 
 */
package com.pcloud.book.book.service.impl;

import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.book.biz.BookRaysClassifyBiz;
import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.dto.AdviserBookStatisDto;
import com.pcloud.book.book.dto.AdviserBookStatisRequestDto;
import com.pcloud.book.book.dto.AviserBookInfoParam;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.dto.BookCountAndAdviserIdDTO;
import com.pcloud.book.book.dto.BookCountByAdvisersDto;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookRequestVO;
import com.pcloud.book.book.dto.BookResourceStatisticsDTO;
import com.pcloud.book.book.dto.BookRightsSettingDTO;
import com.pcloud.book.book.dto.BookStatisticsResultDto;
import com.pcloud.book.book.dto.BookVarietyStatsDto;
import com.pcloud.book.book.dto.BookVarietyStatsRequestDto;
import com.pcloud.book.book.dto.MapResourceTotalCountDTO;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.book.service.BookAdviserService;
import com.pcloud.book.group.dto.BookAppletSceneDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @描述：编辑推广书籍接口类实现类
 * @作者：songx
 * @创建时间：2017年1月4日,下午7:59:13 @版本：1.0
 */
@RestController("bookAdviserService")
@RequestMapping("bookAdviserService")
public class BookAdviserServiceImpl implements BookAdviserService {

	@Autowired
	private BookAdviserBiz bookAdviserBiz;
	@Autowired
    private BookRaysClassifyBiz bookRaysClassifyBiz;


	@Override
	@GetMapping(value = "/listByAdviserId")
	public ResponseEntity<ResponseDto<List<BookDto>>> listByAdviserId(@RequestParam("adviserId") Long adviserId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.listByAdviserId(adviserId));
	}

    @Override
	@GetMapping("getXiaoRuiClassifyIdByBookId")
	public ResponseEntity<ResponseDto<Long>> getXiaoRuiClassifyIdByBookId(@RequestParam("bookId") Long bookId,
																   @RequestParam("channelId") Long channelId,
																   @RequestParam("adviserId") Long adviserId) throws BizException{
        Long classifyIdByBookId = bookRaysClassifyBiz.getClassifyId(bookId, adviserId, channelId);
        return ResponseHandleUtil.toResponse(classifyIdByBookId);
    }

	@Override
	public ResponseEntity<ResponseDto<Integer>> getBookIsOpenProcess(Long bookId, Long channelId, Long adviserId) throws BizException {
		BookAdviserDto base = bookAdviserBiz.getBase(bookId, channelId, adviserId);
		if(base!=null){
			return ResponseHandleUtil.toResponse(base.getIsOpenRobotProcess());
		}

		return  null;
	}

	/**
	 * 获取编辑的推广书籍总数
	 */
	@Override
	@RequestMapping(value = "/getCountByAdvisers", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Map<Long, BookAdviserDto>>> getCountByAdvisers(
			@RequestBody(required = false) List<Long> adviserIds) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getCountByAdvisers(adviserIds));
	}

	/**
	 * 根据ISBN获取书籍信息
	 */
	@Override
	@RequestMapping(value = "/getByIsbn", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<BookAdviserDto>> getByIsbn(
			@RequestParam(value = "isbn", required = false) String isbn,
			@RequestParam(value = "channelId", required = false) Long channelId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getByIsbn(isbn, channelId));
	}

	/**
	 * 根据图书信息获取主编辑ID
	 */
	@Override
	@RequestMapping(value = "/getMainAdviserId", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Long>> getMainAdviserId(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getMainAdviserId(bookId, channelId));
	}

	/**
	 * 创建默认图书与编辑的关系
	 */
	@Override
	@RequestMapping(value = "/createDefaultBook", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Long>> createDefaultBook(
			@RequestParam(value = "adviserId", required = false) Long adviserId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.createDefaultBook(null, adviserId));
	}

	/**
	 * 设置图书使用模板
	 */
	@Override
	@RequestMapping(value = "/setBookTemplet", method = RequestMethod.POST)
	public void setBookTemplet(@RequestBody BookAdviser bookAdviser) throws BizException {
		bookAdviserBiz.setBookTemplet(bookAdviser);
	}

	@Override
	@PostMapping("listAdviserBookInfo")
	public ResponseEntity<ResponseDto<Map<String,AdviserBookInfoDTO>>> listAdviserBookInfo(@RequestBody AviserBookInfoParam AviserBookInfoParam) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.listAdviserBookInfo(AviserBookInfoParam));
	}

	@Override
	@PostMapping("getBookCountByAdviserId")
	public ResponseEntity<ResponseDto<Map<Long, BookCountAndAdviserIdDTO>>> getBookCountByAdviserId(@RequestBody BookCountByAdvisersDto bookCountByAdvisersDto) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getBookCountByAdviserId(bookCountByAdvisersDto));
	}

	@Override
	@GetMapping("refactorData")
	public ResponseEntity<ResponseDto<String>> refactorData(@RequestParam("parentId") Long parentId,
															@RequestParam("originTempletId") Long originTempletId,
															@RequestParam(value = "secondTempletId",required = false) Long secondTempletId) throws BizException {
		if(Objects.isNull(parentId) || Objects.isNull(originTempletId)){
			return ResponseHandleUtil.toResponse("param is wrong");
		}

		bookAdviserBiz.refactorData(parentId,originTempletId,secondTempletId);
		return ResponseHandleUtil.toResponse("ok");
	}

	@Override
	@GetMapping("getBookRightsSetting")
	public ResponseEntity<ResponseDto<BookRightsSettingDTO>>getBookRightsSetting(
			@RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
			@RequestParam("adviserId") Long adviserId) {
		BookRightsSettingDTO bookRightsSettingDTO = bookAdviserBiz.getBookRightsSetting(bookId,channelId,adviserId);
		return ResponseHandleUtil.toResponse(bookRightsSettingDTO);
	}

	@Override
	@PostMapping("mapResourceTotalCount")
	public ResponseEntity<ResponseDto<Map<String, BookResourceStatisticsDTO>>> mapResourceTotalCount(@RequestBody MapResourceTotalCountDTO mapResourceTotalCountDTO) {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.mapResourceTotalCount(mapResourceTotalCountDTO.getAdviserIds(), mapResourceTotalCountDTO.getBookIds(), mapResourceTotalCountDTO.getChannelIds()));
	}

	@Override
	@PostMapping("/getAdviserBookVarietyStats")
	public ResponseEntity<ResponseDto<Map<Long, BookVarietyStatsDto>>> getAdviserBookVarietyStats(@RequestBody List<BookVarietyStatsRequestDto> requestDtos) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getAdviserBookVarietyStats(requestDtos));
	}

	@Override
	@GetMapping("getBookCountByAgentId")
	public ResponseEntity<ResponseDto<Integer>> getBookCountByAgentId(@RequestParam("agentId") Long agentId) throws BizException{
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getBookCount(agentId));
	}

	@Override
	@GetMapping("getBookByBookIdAdviserIdChannelId")
	public ResponseEntity<ResponseDto<BookDto>>getBookByBookIdAdviserIdChannelId(
			@RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
			@RequestParam("adviserId") Long adviserId) {
		BookDto bookDto = bookAdviserBiz.getBookByBookIdAdviserIdChannelId(bookId,channelId,adviserId);
		return ResponseHandleUtil.toResponse(bookDto);
	}

	@Override
	@GetMapping("getBookAppletByBookId")
	public ResponseEntity<ResponseDto<BookAppletSceneDTO>> getBookAppletByBookId(@RequestParam("bookId") Long bookId,
																				 @RequestParam("channelId") Long channelId,
																				 @RequestParam("adviserId") Long adviserId) {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getBookAppletByBookId(bookId, channelId, adviserId));
	}

	@Override
	@PostMapping("getHasWxWorkCode")
	public ResponseEntity<ResponseDto<List<Long>>> getHasWxWorkCode(@RequestBody List<Long> sceneIds) {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getHasWxWorkCode(sceneIds));
	}

	@Override
	@PostMapping("getHasResourceCode")
	public ResponseEntity<ResponseDto<List<Long>>> getHasResourceCode(@RequestBody List<Long> sceneIds) {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getHasResourceCode4Erp(sceneIds));
	}

	@Override
	public void getBookIdsByAgentId(Long agentId) {
		bookAdviserBiz.getBookIdsByAgentId(agentId);
	}

	@Override
	@PostMapping("getBookRightsCount")
	public ResponseEntity<ResponseDto<Map<String, BookStatisticsResultDto>>> getBookRightsCount(@RequestBody List<BookRequestVO> requestVOS){
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getBookRightsCount(requestVOS));
	}

	@Override
	@GetMapping("getBookIsOpenCatalog")
	public ResponseEntity<ResponseDto<Integer>> getBookIsOpenCatalog(@RequestParam("bookId") Long bookId,
															  @RequestParam("channelId") Long channelId,
															  @RequestParam("adviserId") Long adviserId) throws BizException {
		Integer isOpenCatalog = bookAdviserBiz.getBookIsOpenCatalog(bookId, channelId, adviserId);
		return ResponseHandleUtil.toResponse(isOpenCatalog);
	}

	@GetMapping("getAllAdviserBook")
	@Override
	public ResponseEntity<ResponseDto<PageBeanNew<AdviserBookInfoDTO>>> getAllAdviserBook(@RequestParam("currentPage") Integer currentPage,
																				   @RequestParam("numPerPage") Integer numPerPage) {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getAllAdviserBook(currentPage, numPerPage));
	}

	@PostMapping("getBookMapByAdviserBookIds")
	@Override
	public ResponseEntity<ResponseDto<Map<Long, BookDto>>> getBookMapByAdviserBookIds(@RequestBody List<Long> adviserBookIds) {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getBookMapByAdviserBookIds(adviserBookIds));
	}

	@Override
	@GetMapping("hasApprovalBook4Adviser")
	public ResponseEntity<ResponseDto<Boolean>> hasApprovalBook4Adviser(@RequestParam("adviserId") Long adviserId) {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.hasApprovalBook4Adviser(adviserId));
	}

	@Override
	@PostMapping("getAdviserBookStatis")
	public ResponseEntity<ResponseDto<Map<Long, AdviserBookStatisDto>>> getAdviserBookStatis(AdviserBookStatisRequestDto requestDto) {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getAdviserBookStatis(requestDto));
	}

	@Override
	@GetMapping("getBookCreateCount")
	public ResponseEntity<ResponseDto<Integer>> getBookCreateCount(@RequestParam("adviserId") Long adviserId,
															@RequestParam(value = "startTime",required = false) String startTime) {
		Integer count = bookAdviserBiz.getBookCreateCount(adviserId, startTime);
		return ResponseHandleUtil.toResponse(count);
	}
}
