package com.pcloud.book.consumer.app;

import cn.hutool.core.collection.CollUtil;
import com.pcloud.appcenter.app.dto.AppCountDto;
import com.pcloud.appcenter.app.dto.AppDto;
import com.pcloud.appcenter.app.dto.AppIdTypeDTO;
import com.pcloud.appcenter.app.dto.AppRaysDTO;
import com.pcloud.appcenter.app.dto.AppTypeDto;
import com.pcloud.appcenter.app.dto.app.MapBaseStatusDTO;
import com.pcloud.appcenter.app.service.AppService;
import com.pcloud.appcenter.app.service.AppTypeService;
import com.pcloud.appcenter.base.dto.AppPriceCacheDTO;
import com.pcloud.appcenter.cache.service.AppPriceCacheService;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 应用接口
 * 
 * @author 作者 : lili
 * @date 创建时间：2016年12月2日 下午7:09:15
 * @version 1.0
 * @return
 */
@Repository("appConsr")
public class AppConsr {
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(AppConsr.class);

	@Autowired
	private AppService appService;
	@Autowired
	private AppPriceCacheService appPriceCacheService;
	@Autowired
	private AppTypeService appTypeService;

	/**
	 * 获取审核通过的应用
	 */
	public Map<Long, AppDto> listPassById(List<Long> appIds) throws BizException {
		LOGGER.info("获取审核通过的应用[appService.listPassById],参数列表[appIds]:" + appIds);
		Map<Long, AppDto> appDtos = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return appDtos;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, AppDto>>> appDtosEntity = appService.listPassById(appIds);
			appDtos = ResponseHandleUtil.parseMapResponse(appDtosEntity, Long.class, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取审核通过的应用[appService.listPassById]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取审核通过的应用[appService.listPassById]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取审核通过的应用失败~!");
		}
		return appDtos;
	}

	/**
	 * 获取应用基本信息
	 * 
	 * @param appIds
	 * @param object
	 * @return
	 */
	public Map<Long, AppDto> mapByIds(List<Long> appIds) {
		LOGGER.info("获取应用基本信息[appService.mapByIds],参数列表[appIds]:" + appIds);
		Map<Long, AppDto> appDtos = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return appDtos;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, AppDto>>> appDtosEntity = appService.mapByIds(appIds);
			appDtos = ResponseHandleUtil.parseMapResponse(appDtosEntity, Long.class, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取应用基本信息[appService.mapByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取应用基本信息[appService.mapByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取应用基本信息失败~!");
		}
		return appDtos;
	}

	public Map<Long, AppDto> mapBaseByIds(List<Long> appIds) {
		LOGGER.info("获取应用基本信息[appService.mapByIds],参数列表[appIds]:" + appIds);
		Map<Long, AppDto> appDtos = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return appDtos;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, AppDto>>> appDtosEntity = appService.mapBaseByIds(appIds);
			appDtos = ResponseHandleUtil.parseMapResponse(appDtosEntity, Long.class, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取应用基本信息[appService.mapByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取应用基本信息[appService.mapByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取应用基本信息失败~!");
		}
		return appDtos;
	}

	/**
	 * 获取应用基本信息
	 * @param appIds 应用ID列表
	 * @return
	 */
	public Map<Long, AppDto> getBaseByIds(List<Long> appIds) {
		LOGGER.info("获取应用基本信息[appService.getBaseByIds],参数列表[appIds]:" + appIds);
		Map<Long, AppDto> appDtos = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return appDtos;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, AppDto>>> appDtosEntity = appService.getBaseByIds(appIds);
			appDtos = ResponseHandleUtil.parseMapResponse(appDtosEntity, Long.class, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取应用基本信息[appService.getBaseByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取应用基本信息[appService.getBaseByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取应用基本信息失败~!");
		}
		return appDtos;
	}

	/**
	 * 根据id获取应用基本信息
	 *
	 * @param appId 应用ID
	 * @return
	 */
	public AppDto getBaseById(Long appId) {
		LOGGER.info("根据id获取应用基本信息[appService.getBaseById],参数列表[getBaseById]:" + appId);
		AppDto appDto = null;
		if (appId == null) {
			return appDto;
		}
		try {
			ResponseEntity<ResponseDto<AppDto>> appDtosEntity = appService.getBaseById(appId);
			appDto = ResponseHandleUtil.parseResponse(appDtosEntity, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("根据id获取应用基本信息[appService.getBaseById]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("根据id获取应用基本信息[appService.getBaseById]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "根据id获取应用基本信息失败~!");
		}
		return appDto;
	}

	@ParamLog("批量获取应用场景值")
	public Map<Long, String> listSceneNameByIds(List<Long> appIds) {
		Map<Long, String> map = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return map;
		}
		try {
			map = ResponseHandleUtil.parseMapResponse(appService.listSceneNameByIds(appIds), Long.class, String.class);
		} catch (BizException e) {
			LOGGER.warn("批量获取应用场景值[appService.listSceneNameByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("批量获取应用场景值[appService.listSceneNameByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "批量获取应用场景值失败~!");
		}
		return map;
	}

	/**
	 * 获取应用价格
	 * @param appPriceCacheDTOS
	 * @return
	 */
	public Map<Long, BigDecimal> getAppPrice(List<AppPriceCacheDTO> appPriceCacheDTOS) {
		Map<Long, BigDecimal> appPrices = null;
		if(ListUtils.isEmpty(appPriceCacheDTOS)){
			return null;
		}
		try{
			appPrices = ResponseHandleUtil.parseMapResponse(appPriceCacheService.getCaches(appPriceCacheDTOS), Long.class, BigDecimal.class);
		}catch (Exception e){
			LOGGER.error("获取应用价格失败"+e.getMessage(),e);
		}
		return appPrices;
	}

	public Map<Long, AppDto> mapByIds4AuditPass(List<Long> appIds) {
		LOGGER.info("获取应用基本信息过滤掉从来没有审核通过的[appService.mapByIds],参数列表[appIds]:" + appIds);
		Map<Long, AppDto> appDtos = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return appDtos;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, AppDto>>> appDtosEntity = appService.mapByIds4AuditPass(appIds);
			appDtos = ResponseHandleUtil.parseMapResponse(appDtosEntity, Long.class, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取应用基本信息[appService.mapByIds4AuditPass]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取应用基本信息[appService.mapByIds4AuditPass]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "mapByIds4AuditPass获取应用基本信息失败~!");
		}
		return appDtos;
	}

	public Map<String, AppTypeDto> listAllCode(){
		try {
			Map<String, AppTypeDto> appTypeDtoMap = new HashMap<>();
			ResponseEntity<ResponseDto<Map<String, AppTypeDto>>> appDtosEntity = appTypeService.listAllCode();
			appTypeDtoMap = ResponseHandleUtil.parseMapResponse(appDtosEntity, String.class, AppTypeDto.class);
			if (appTypeDtoMap == null) {
				return new HashMap<>();
			}
			return appTypeDtoMap;
		} catch (BizException e) {
			LOGGER.warn("获取应用类型名称[appTypeService.listAllCode]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取应用类型名称[appTypeService.listAllCode]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "listAllCode 获取应用类型名称失败~!");
		}
	}

	@ParamLog("RAYS应用")
	public Map<Long, AppRaysDTO> mapRaysApp(List<Long> raysAppIds) {
		Map<Long, AppRaysDTO> map = new HashMap<>();
		if (ListUtils.isEmpty(raysAppIds)) {
			return map;
		}
		try {
			map = ResponseHandleUtil.parseMapResponse(appService.mapRaysApp(raysAppIds), Long.class, AppRaysDTO.class);

		} catch (Exception e) {
			LOGGER.error("调用失败" + e.getMessage(), e);
		}
		return map;
	}

	@ParamLog("getRaysAppTypeCodes")
	public List<String> getRaysAppTypeCodes() {
		return ResponseHandleUtil.parseList(appService.getRaysAppTypeCodes(), String.class);
	}

	public List<AppIdTypeDTO> listAppTypeById(List<Long> appIds) {
		if (CollUtil.isEmpty(appIds)) return new ArrayList<>();
		try {
			return ResponseHandleUtil.parseList(appService.listAppTypeById(appIds), AppIdTypeDTO.class);
		} catch (Exception e) {
			LOGGER.warn("根据ID获取code失败！,appIds:{}", appIds, e);
			return new ArrayList<>();
		}
	}

	public Map<Long, AppCountDto> getCount4Adviser(List<Long> adviserIds) {
		if (CollUtil.isEmpty(adviserIds)) return new HashMap<>();
		try {
			return ResponseHandleUtil.parseMapResponse(appService.getCount4Adviser(adviserIds), Long.class, AppCountDto.class);
		} catch (Exception e) {
			LOGGER.warn("根据ID获取应用数理失败！, adviserIds:{}", adviserIds, e);
			return new HashMap<>();
		}
	}


	@ParamLog("查应用关联的公众号工具的付费公众号")
	public Map<Long, Long> getPayOfficialAccountsToolByAppIds(List<Long> appIds) {
		if (ListUtils.isEmpty(appIds)) {
			return new HashMap<>();
		}
		try {
			return ResponseHandleUtil.parseMapResponse(appService.getPayOfficialAccountsToolByAppIds(appIds), Long.class, Long.class);
		} catch (Exception e) {
			LOGGER.error("调用appService.getPayOfficialAccountsToolByAppIds失败"+e.getMessage(), e);
		}
		return new HashMap<>();
	}

	@ParamLog(description = "获取应用状态与价格", isAfterReturn = false)
	public Map<Long, MapBaseStatusDTO> mapBaseStatusById(List<Long> appIds){
		if(ListUtils.isEmpty(appIds)) return null;
		try{
			Map<Long, MapBaseStatusDTO>  appBaseStatus = ResponseHandleUtil.parseMap(appService.mapBaseStatusById(appIds), Long.class, MapBaseStatusDTO.class);
			return appBaseStatus;
		}catch (Exception e){
			LOGGER.error("获取应用状态与价格失败"+ e.getMessage(), e);
		}
		return null;
	}

	@ParamLog(description = "获取应用基本信息与价格", isAfterReturn = false)
	public Map<Long, AppDto> mapBaseWithPriceByIds(List<Long> appIds){
		if(ListUtils.isEmpty(appIds)) return null;
		try{
			Map<Long, AppDto>  appBaseStatus = ResponseHandleUtil.parseMap(appService.mapBaseWithPriceByIds(appIds), Long.class, AppDto.class);
			return appBaseStatus;
		}catch (Exception e){
			LOGGER.error("获取应用基本信息与价格失败"+ e.getMessage(), e);
		}
		return null;
	}


	@ParamLog("RAYS应用")
	public Map<String, AppRaysDTO> mapRaysAppByType(List<String> typeCodes) {
		Map<String, AppRaysDTO> map = new HashMap<>();
		if (ListUtils.isEmpty(typeCodes)) {
			return map;
		}
		try {
			map = ResponseHandleUtil.parseMapResponse(appService.mapRaysAppByType(typeCodes), String.class, AppRaysDTO.class);

		} catch (Exception e) {
			LOGGER.error("调用失败" + e.getMessage(), e);
		}
		return map;
	}
}
