package com.pcloud.book.consumer.book.elasticsearch;

import com.pcloud.book.elasticsearch7.domain.dto.param.BookExtendImgSearchDto;
import com.pcloud.book.elasticsearch7.domain.dto.param.BookSearchDto;
import com.pcloud.book.elasticsearch7.domain.dto.param.PlatformSearchDto;
import com.pcloud.book.elasticsearch7.domain.entity.Es7Book;
import com.pcloud.book.elasticsearch7.service.Es7BookExtendImgService;
import com.pcloud.book.elasticsearch7.service.Es7BookSearchService;
import com.pcloud.book.elasticsearch7.service.PlatformBookSearchService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.universe.commons.paging.Pagination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * book elasticsearch
 */
@Component
public class BookElasticSearchConsr {

    /**
     * logger
     */
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private PlatformBookSearchService platformBookSearchService;
    @Autowired
    private Es7BookExtendImgService es7BookExtendImgService;
    @Autowired
    private Es7BookSearchService es7BookSearchService;

    public Pagination<Es7Book> search(PlatformSearchDto dto) {
        try {
            ResponseDto<Pagination<Es7Book>> r = platformBookSearchService.search(dto);
            return r.getData();
        } catch (Exception e) {
            logger.error("platform book es search exception.", e);
        }
        return new Pagination<>();
    }

    public List<String> searchBookExtendImg(BookExtendImgSearchDto dto) {
        try {
            List<String> search = es7BookExtendImgService.search(dto);
            return search;
        } catch (Exception e) {
            logger.error("bookExtendImg es search exception.", e);
        }
        return new ArrayList<>();
    }

    public Pagination<Es7Book> getAdviserBooks4Erp(BookSearchDto param) {
        try {
            Pagination<Es7Book> r = es7BookSearchService.getAdviserBooks4Erp(param);
            return r;
        } catch (Exception e) {
            logger.error("platform book es search exception.", e);
        }
        return new Pagination<>();
    }
}
