/**
 * 
 */
package com.pcloud.book.consumer.message;

import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.consumer.reader.ReaderConsr;
import com.pcloud.book.consumer.user.ChannelConsr;
import com.pcloud.channelcenter.wechat.entity.AccountSetting;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.biz.TemplateQueueBiz;
import com.pcloud.common.core.constant.SceneCode;
import com.pcloud.common.core.constant.SendType;
import com.pcloud.common.core.constant.WechatCode;
import com.pcloud.common.core.dto.AppletTemplateMessageDto;
import com.pcloud.common.core.dto.TemplateMessageDto;
import com.pcloud.common.exceptions.BizException;

import com.pcloud.common.utils.ListUtils;
import com.pcloud.readercenter.common.utils.ReaderConstants;
import com.pcloud.readercenter.wechat.entity.WechatUserOfficialAccounts;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @描述：发送模板消息
 * @作者：songx
 * @创建时间：2016年11月18日,上午9:56:03
 * @版本：1.0
 */
@Component("templetConsr")
public class TemplateConsr {
	
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(TemplateConsr.class);

	@Autowired
	private TemplateQueueBiz templateQueueBiz;
	@Autowired
	private ReaderConsr readerConsr;
	@Value("${operate_official_id}")
	private Long operateOfficalId;
	@Autowired
	private ChannelConsr channelConsr;

	/**
	 * 发送模板消息topic(管理公众号)
	 */
	public void sendManage(String SceneCode, Long sendPartyId, Long receivePartyId, String receivePartyRole, String url,
			Map<String, String> temParam, String sendType, boolean isApp) throws BizException {
		LOGGER.info("【模板消息(消)】发送模板消息topic(管理公众号),<PARAM>.[receivePartyId]=" + receivePartyId + ",[sendPartyId]="
				+ sendPartyId + ",[temParam]=" + temParam.toString());
		// 组装参数对象
		TemplateMessageDto templateMessageDto = new TemplateMessageDto();
		templateMessageDto.setSceneCode(SceneCode);
		templateMessageDto.setSendPartyId(sendPartyId);
		templateMessageDto.setSendPartyRole(WechatCode.AGENT.value);
		templateMessageDto.setUrl(url);
		templateMessageDto.setTemParam(temParam);
		templateMessageDto.setSendType(sendType);
		templateMessageDto.setReceivePartyId(receivePartyId);
		templateMessageDto.setReceivePartyRole(receivePartyRole);
		templateMessageDto.setIsApp(isApp);
		try {
			templateQueueBiz.sendMessageQueue(templateMessageDto);
		} catch (Exception e) {
			LOGGER.error("【模板消息(消)】发送模板消息topic(管理公众号),<ERROR>.[sendMessageQueue]:" + e.getMessage(), e);
		}
	}

	public void sendOperate(String SceneCode, Long sendPartyId, Long wechatUserId, String url,
						   Map<String, String> temParam, String sendType, boolean isApp) throws BizException {
		// 组装参数对象
		TemplateMessageDto templateMessageDto = new TemplateMessageDto();
		templateMessageDto.setSceneCode(SceneCode);
		templateMessageDto.setSendPartyId(sendPartyId);
		templateMessageDto.setSendPartyRole(WechatCode.CHANNEL.value);
		templateMessageDto.setUrl(url);
		templateMessageDto.setTemParam(temParam);
		templateMessageDto.setSendType(sendType);
		templateMessageDto.setWechatUserId(wechatUserId);
		templateMessageDto.setIsApp(isApp);
		try {
			templateQueueBiz.sendMessageQueue(templateMessageDto);
		} catch (Exception e) {
			LOGGER.error("【模板消息(消)】发送模板消息topic(运营号),<ERROR>.[sendMessageQueue]:" + e.getMessage(), e);
		}
	}

	@ParamLog("发送小程序模板消息")
	public void sendAppletMessageQueue(AppletTemplateMessageDto appletTemplateMessage) {
		try {
			templateQueueBiz.sendAppletMessageQueue(appletTemplateMessage);
		} catch (Exception e) {
			LOGGER.error("【小程序模板消息(消)】发送小程序模板消息topic,<ERROR>.[sendAppletMessageQueue]:" + e.getMessage(), e);
		}
	}

	public void sendTempletMessage4Project(String keyword1, String keyword2, Long wechatUserId, String pagepath, String first) {
		LOGGER.info("小睿宠物发送模板消息业务进度提醒keyword1：{}，keyword2：{}，  wechatUserId：{}，pagepath：{}，",
				keyword1, keyword2,wechatUserId, pagepath);
		Map<String, String> temParam = new HashMap<>();
		temParam.put("first", first);
		temParam.put("keyword1", keyword1);
		temParam.put("keyword2", keyword2);
		temParam.put("remark", "点击查看详情");
		List<Long> allUserIds = readerConsr.getAllUserIds(wechatUserId);
		if (ListUtils.isEmpty(allUserIds)) {
			return;
		}
		Map<Long, WechatUserOfficialAccounts> userOfficalAccountMap = readerConsr.getUserOfficalAccountMap(allUserIds);
		if (MapUtils.isEmpty(userOfficalAccountMap)) {
			return;
		}
		List<WechatUserOfficialAccounts> wechatUserOfficialAccounts = userOfficalAccountMap.values().stream().filter(e -> operateOfficalId.equals(e.getOfficialAccountsId())).collect(Collectors.toList());
		if (ListUtils.isEmpty(wechatUserOfficialAccounts)) {
			return;
		}
		//公众号用户id
		wechatUserId = wechatUserOfficialAccounts.get(0).getWechatUserId();
		// 组装参数对象
		TemplateMessageDto templateMessageDto = new TemplateMessageDto();
		templateMessageDto.setSceneCode(SceneCode.PROJECT_TASK_SCENE.value);
		templateMessageDto.setAccountSettingId(operateOfficalId);
		AccountSetting officialAccountsInfo = channelConsr.getAppInfo(ReaderConstants.MINI_OFFICIAL_ID);
		templateMessageDto.setMiniprogramAppid(officialAccountsInfo.getDeveloperAppId());
		templateMessageDto.setMiniprogramPagepath(pagepath);
		templateMessageDto.setTemParam(temParam);
		templateMessageDto.setSendType( SendType.SEND_BY_WECHAT.value);
		templateMessageDto.setWechatUserId(wechatUserId);
		templateMessageDto.setIsApp(false);
		try {
			templateQueueBiz.sendMessageQueue(templateMessageDto);
		} catch (Exception e) {
			LOGGER.error("【模板消息(消)】发送模板消息-业务进度提醒小睿宠物发送模板消息,<ERROR>.[sendMessageQueue]:" + e.getMessage(), e);
		}
		LOGGER.info("小小睿宠物发送模板消息业务进度提醒[END]");
	}
}
