/**
 * 
 */
package com.pcloud.book.consumer.user;

import com.pcloud.common.core.biz.OperationLogQueueBiz;
import com.pcloud.common.core.dto.OperationLogDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @描述：操作日志记录
 * @作者：songx
 * @创建时间：2016年11月28日,下午8:55:57
 * @版本：1.0
 */
@Component("operationQueue")
public class OperationConsr {

	/**
	 * 
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(OperationConsr.class);
	
	@Autowired
	private OperationLogQueueBiz operationLogQueueBiz;
	
	/**
	 * 发送操作日志记录topic消息
	 */
	public void send(Long agentId, Long editorId, String content, String ip,String token) throws BizException {
		LOGGER.info("【操作日志(消)】发送操作日志记录topic消息,<START>.[agentId]=" + agentId + ",[editorId]=" + editorId + ",[content]="
				+ content + ",[ip]=" + ip);
		if (StringUtil.isEmpty(content) || null == editorId) {
			return;
		}
		// 组装参数对象
		OperationLogDto operationLogDto = new OperationLogDto();
		operationLogDto.setAgentId(agentId);
		operationLogDto.setEditorId(editorId);
		operationLogDto.setContent(content);
		operationLogDto.setTime(DateUtils.nowTimeStamp());
		operationLogDto.setIp(ip);
		operationLogDto.setToken(token);
		// 开发发送消息
		try {
			operationLogQueueBiz.send(operationLogDto);
		} catch (Exception e) {
			LOGGER.error("【操作日志(消)】发送操作日志记录topic消息.[send]:" + e.getMessage(), e);
		}
		LOGGER.info("【操作日志(消)】发送操作日志记录topic消息,<END>");
	}
	
}
