package com.pcloud.book.copyright.biz;

import com.pcloud.book.copyright.dto.BookAuthCodeDTO;
import com.pcloud.book.copyright.dto.DeleteAuthCodeDTO;
import com.pcloud.book.copyright.dto.SceneAuthCodeResponseDTO;
import com.pcloud.book.copyright.dto.SceneAuthCodeSearchDTO;
import com.pcloud.book.copyright.entity.BookSceneAuth;
import com.pcloud.book.copyright.vo.CheckAuthCodeVO;
import com.pcloud.book.copyright.vo.GenerateCodeVO;
import com.pcloud.book.copyright.vo.UseAuthCodeVO;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;
import java.util.Map;

/**
 * 书籍二维码授权表(BookSceneAuth)表服务接口
 *
 * @author makejava
 * @since 2021-10-19 14:14:22
 */
public interface BookSceneAuthBiz {


    /**
     *  自动创建授权码
     */
    void autoGenerateAuthCode(GenerateCodeVO generateCodeVO, Long adviserId);

    /**
     * 二维码下授权码列表
     */
    PageBeanNew<BookAuthCodeDTO> listSceneAuthCode(Long bookId, Long channelId, Long sceneId, String keyword, Integer state, Integer authBookType, Integer currentPage, Integer numPerPage, Long adviserId);

    /**
     *  删除授权码
     */
    void deleteSceneAuthCode(List<Long> ids);

    /**
     * 一键清空未使用的授权码
     */
    void clearNoUsedAuthCode(DeleteAuthCodeDTO deleteAuthCodeDTO, Long adviserId);

    /**
     *  升级用户扫描授权码之后
     */
    CheckAuthCodeVO checkSceneAuthCode(UseAuthCodeVO useAuthCodeVO, Long channelId, Long wechatUserId);

    /**
     * 修改二维码授权信息
     */
    void setBookCodeAuth(BookSceneAuth bookSceneAuth, Long adviserId);

    /**
     *  保存二维码授权信息
     */
    void saveSceneAuthInfo(List<BookSceneAuth> list, Long adviserId);

    /**
     * 获取二维码授权码信息
     */
    List<SceneAuthCodeResponseDTO> getSceneAuthInfo(SceneAuthCodeSearchDTO sceneAuthCodeSearchDTO);

    /**
     *  升级用户扫描授权码之后
     */
    Map<String, Object> exportSceneAuthCode(Long bookId, String codeIds, Long channelId,Long sceneId, Long status, String systemCode, Long partyId, Integer authBookType);
}