package com.pcloud.book.copyright.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lily
 * @date 2018/12/4 14:37
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class HaveSetAuthBook implements Serializable {
    @ApiModelProperty("主键标识")
    private Long id;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("图书名称")
    private String bookName;

    @ApiModelProperty("封面图")
    private String coverImg;

    @ApiModelProperty("isbn")
    private String isbn;

    @ApiModelProperty("编号")
    private  String serialNumber;

    @ApiModelProperty("正版授权金价格")
    private BigDecimal price;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    @ApiModelProperty("是否是主编辑")
    private Boolean isMainEditor;

    @ApiModelProperty("是否有使用过的授权码")
    private Boolean haveUsedAuthCode;

    @ApiModelProperty("授权类型（1-旧版-二维码+授权码，2-升级，二维码）")
    private Integer authType;

    public Integer getAuthType() {
        return authType;
    }

    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getBookStatus() {
        return bookStatus;
    }

    public void setBookStatus(Integer bookStatus) {
        this.bookStatus = bookStatus;
    }

    public Boolean getMainEditor() {
        return isMainEditor;
    }

    public void setMainEditor(Boolean mainEditor) {
        isMainEditor = mainEditor;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getHaveUsedAuthCode() {
        return haveUsedAuthCode;
    }

    public void setHaveUsedAuthCode(Boolean haveUsedAuthCode) {
        this.haveUsedAuthCode = haveUsedAuthCode;
    }

    @Override
    public String toString() {
        return "HaveSetAuthBook{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", adviserId=" + adviserId +
                ", bookName='" + bookName + '\'' +
                ", coverImg='" + coverImg + '\'' +
                ", isbn='" + isbn + '\'' +
                ", serialNumber='" + serialNumber + '\'' +
                ", price=" + price +
                ", bookStatus=" + bookStatus +
                ", isMainEditor=" + isMainEditor +
                ", haveUsedAuthCode=" + haveUsedAuthCode +
                '}';
    }
}
