package com.pcloud.book.cultivate.constant;

/**
 * @ClassName com.pcloud.book.cultivate.constant.CultivateRaysConstants
 * @Author zhuyajie
 * @Description 新版宠物小睿
 * @Date 2021/7/16 14:22
 * @Version 1.0
 **/
public class CultivateRaysConstants {


    /**
     * 宠物状态 0饥饿1进食
     * @author：zhuyajie
     * @date：2021/7/16 14:24
     *  * @param null
     */
    public enum CultivateRaysState{
        HUNGRY(0),
        EATING(1);
        private Integer code;

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        CultivateRaysState(Integer code) {
            this.code = code;
        }
    }

    /**
     * 收入类型及兑换
     * @author：zhuyajie
     * @date：2021/7/16 14:40
     *  * @param null
     */
    public enum GainsConversionEnum {
        /**
         * 类型，名称，可兑换x时长，x书币兑换1个
         */
        GAINS1(1,"小鱼干", 5,3),
        GAINS2(2,"面包",10,5),
        GAINS3(3,"大餐",24,10);
        private Integer type;
        private String typeName;
        private Integer hours;
        private Integer cost;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getTypeName() {
            return typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public Integer getHours() {
            return hours;
        }

        public void setHours(Integer hours) {
            this.hours = hours;
        }

        public Integer getCost() {
            return cost;
        }

        public void setCost(Integer cost) {
            this.cost = cost;
        }

        GainsConversionEnum(Integer type, String typeName, Integer hours, Integer cost) {
            this.type = type;
            this.typeName = typeName;
            this.hours = hours;
            this.cost = cost;
        }

        public static Integer getHoursByType(Integer type) {
            for (GainsConversionEnum conversionEnum:GainsConversionEnum.values()) {
                if (conversionEnum.type.equals(type)){
                    return conversionEnum.hours;
                }
            }
            return null;
        }
        public static Integer getCostByType(Integer type) {
            for (GainsConversionEnum conversionEnum:GainsConversionEnum.values()) {
                if (conversionEnum.type.equals(type)){
                    return conversionEnum.cost;
                }
            }
            return null;
        }
        public static String getNameByType(Integer type) {
            for (GainsConversionEnum conversionEnum:GainsConversionEnum.values()) {
                if (conversionEnum.type.equals(type)){
                    return conversionEnum.typeName;
                }
            }
            return null;
        }
    }


    /**
     * 变化类型
     * @author：zhuyajie
     * @date：2021/7/16 18:15
     *  * @param null
     */
    public enum ChangeTypeEnum{
        RMALL_MONEY_CONVERSION(1),
        GAINS_CONVERSION(2);
        private Integer code;

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        ChangeTypeEnum(Integer code) {
            this.code = code;
        }
    }

    //延时队列-时间消耗
    public static final String HOURS_CONSUMPTION_DELAY="HOURS_CONSUMPTION_DELAY";

    //缓存-指引
    public static final String GUIDE_REDIS ="book:cultivate_guide";
}
