package com.pcloud.book.group.biz;

import com.pcloud.book.group.entity.ResourcePageOuterLink;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;

/**
 * (ResourcePageOuterLink)表服务接口
 *
 * @author wubo 
 * @since 2022-05-17 14:14:08
 */
public interface ResourcePageOuterLinkBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    ResourcePageOuterLink getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param resourcePageOuterLink 实例对象
     * @return 主键
     */
    Long insert(ResourcePageOuterLink resourcePageOuterLink);

    /**
     * 修改数据
     *
     * @param resourcePageOuterLink 实例对象
     */
    void update(ResourcePageOuterLink resourcePageOuterLink);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 通过主键软删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void softDeleteById(Long id);

    /**
     * 批量新增
     * @param addOuterLink
     */
    void batchInsert(List<ResourcePageOuterLink> addOuterLink);


    /**
     * 批量获取
     * @param resourcePageOuterLinkIds
     * @return
     */
    List<ResourcePageOuterLink> selectList(List<Long> resourcePageOuterLinkIds);
}
