package com.pcloud.book.group.biz.impl;

import com.pcloud.book.group.biz.BookGroupDataBiz;
import com.pcloud.book.group.dao.ResourcePageItemDao;
import com.pcloud.book.group.dto.BookGroupServiceDTO;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ListUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 */
@Component("bookGroupDataBiz")
public class BookGroupDataBizImpl implements BookGroupDataBiz {

    @Autowired
    private ResourcePageItemDao resourcePageItemDao;

    @Override
    public Map<Long, List<BookGroupServiceDTO>> getBookGroupService(List<Long> bookGroupIds) {
        Map<Long, List<BookGroupServiceDTO>> resultMap = new HashMap<>();
        if (ListUtils.isEmpty(bookGroupIds)) {
            return resultMap;
        }
        List<BookGroupServe> resultList = resourcePageItemDao.getServeListByBookGroupIds(bookGroupIds);
        if (ListUtils.isEmpty(resultList)) {
            return new HashMap<>();
        }
        for (BookGroupServe bookGroupServe : resultList) {
            Long bookGroupId = bookGroupServe.getBookGroupId();
            List<BookGroupServiceDTO> bookGroupServiceDTOS = resultMap.get(bookGroupId);
            if(bookGroupServiceDTOS==null){
                bookGroupServiceDTOS = new ArrayList<>();
            }
            BookGroupServiceDTO dto =new BookGroupServiceDTO();
            BeanUtils.copyProperties(bookGroupServe,dto);
            bookGroupServiceDTOS.add(dto);
            resultMap.put(bookGroupId,bookGroupServiceDTOS);
        }
        return resultMap;
    }
}