package com.pcloud.book.group.biz.impl;

import cn.hutool.core.collection.CollUtil;
import com.pcloud.book.group.entity.ResourcePageOuterLink;
import com.pcloud.book.group.dao.ResourcePageOuterLinkDao;
import com.pcloud.book.group.biz.ResourcePageOuterLinkBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.apache.regexp.RE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * (ResourcePageOuterLink)表服务实现类
 *
 * @author wubo 
 * @since 2022-05-17 14:14:08
 */
@Service("resourcePageOuterLinkBiz")
public class ResourcePageOuterLinkBizImpl implements ResourcePageOuterLinkBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcePageOuterLinkBizImpl.class);

    @Autowired
    private ResourcePageOuterLinkDao resourcePageOuterLinkDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public ResourcePageOuterLink getById(Long id) {
        return resourcePageOuterLinkDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = resourcePageOuterLinkDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(ResourcePageOuterLink resourcePageOuterLink) {
        resourcePageOuterLinkDao.insert(resourcePageOuterLink);
        return resourcePageOuterLink.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(ResourcePageOuterLink resourcePageOuterLink) {
        if(resourcePageOuterLink == null || !NumberUtil.isNumber(resourcePageOuterLink.getId())){
            throw BizException.PARAM_IS_NULL;
        }
        resourcePageOuterLinkDao.update(resourcePageOuterLink);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        resourcePageOuterLinkDao.deleteById(id);
    }
    
    @Override
    @ParamLog("软删除")
    public void softDeleteById(Long id) {
     resourcePageOuterLinkDao.softDeleteById(id);
    }

    @Override
    public void batchInsert(List<ResourcePageOuterLink> addOuterLink) {
        resourcePageOuterLinkDao.insert(addOuterLink);

    }

    @Override
    public List<ResourcePageOuterLink> selectList(List<Long> resourcePageOuterLinkIds) {
        if (CollUtil.isEmpty(resourcePageOuterLinkIds)) {
            return new ArrayList<>();
        }
        List<ResourcePageOuterLink> resourcePageOuterLinks = resourcePageOuterLinkDao.selectList(resourcePageOuterLinkIds);
        return resourcePageOuterLinks;
    }
}
